(function () {
	const controller = "CustomerRM/";
	const app = new Vue({
		el: "#main",
		data() {
			return {
				// Variables para la tabla
				registros: [],
				loading: true,
				texto: "",
				headers: [{ label: traducirFrase("Nombre"), key: "Nombre" }],
				options: [
					{
						action: "categories",
						tooltip: traducirFrase("Categorias de campos"),
						icon: "format_list_numbered",
					},
					{
						action: "fields",
						tooltip: traducirFrase("Editar campos"),
						icon: "assignment",
					},
					{ action: "edit", tooltip: traducirFrase("Editar el CRM"), icon: "edit" },
					{
						action: "delete",
						tooltip: traducirFrase("Eliminar CRM"),
						icon: "delete",
					},
				],
				colores: [
					{ value: "teal", label: traducirFrase("Verde azulado") },
					{ value: "light-blue", label: traducirFrase("Azul claro") },
					{ value: "blue", label: traducirFrase("Azul") },
					{ value: "green", label: traducirFrase("Verde") },
					{ value: "light-green", label: traducirFrase("Verde claro") },
					{ value: "lime", label: traducirFrase("Lima") },
					{ value: "cyan", label: traducirFrase("Cyan") },
					{ value: "yellow", label: traducirFrase("Amarillo") },
					{ value: "amber", label: traducirFrase("Ambar") },
					{ value: "brown", label: traducirFrase("Cafe") },
					{ value: "blue-grey", label: traducirFrase("Gris Azulado") },
					{ value: "grey", label: traducirFrase("Gris") },
					{ value: "red", label: traducirFrase("Rojo") },
					{ value: "pink", label: traducirFrase("Rosa") },
					{ value: "purple", label: traducirFrase("Morado") },
					{ value: "deep-purple", label: traducirFrase("Morado (oscuro)") },
					{ value: "deep-orange", label: traducirFrase("Naranja (oscuro)") },
					{ value: "orange", label: traducirFrase("Naranja") },
					{ value: "indigo", label: traducirFrase("Indigo") },
				],
				// Variables para los modales
				targets: {
					add: false,
					edit: false,
				},
				// Registrar
				one: {
					id: "",
					nombre: "",
					color: "",
					ocultarInfo: false,
				},
				// Editar
				// Paginacion
				pagina: 1,
				cuenta: 1,
				texto: "",

				crmOrigen: "", // CRM del que se editan sus campos o categorias
				// =======================================
				// Parte para los campos del CRM
				modalCamposCRM: false,
				campos: [
					/*
						{
							id: number,
							Nombre: string,
							Valor: string,
							Busqueda: boolean,
							Edicion: number,
							Tipo: number,
							EnEdicion: boolean,
							CRM: string
						}
					*/
				], // Campos del crmOrigen
				campoOriginal: {},
				selectCategorias: [],
				tiposCampo: [
					{ value: 2, label: traducirFrase("Texto") },
					{ value: 1, label: traducirFrase("Texto (multilineas)") },
					{ value: 3, label: traducirFrase("Seleccion") },
					{ value: 4, label: traducirFrase("Checkbox") },
				],
				valoresEdicion: [
					{ value: 0, label: traducirFrase("No visible") },
					{ value: 1, label: traducirFrase("No editable") },
					{ value: 2, label: traducirFrase("Editable") },
					{ value: 3, label: traducirFrase("Solo para el agente") },
				],
				// =======================================
				// Partes para las categorias del CRM
				modalCategoriasCRM: false,
				editandoCategoria: false,
				categorias: [
					/*
						{
							id: string | number,
							CRM: string | number,
							Nombre: string,
							Posicion: number,
							Contraido: boolean,
						}
					*/
				],
				indexCategoriaEnEdicion: -1,
				categoriaEnEdicion: {
					id: -1,
					crm: "",
					Nombre: "",
					Posicion: 0,
					Contraido: false,
				},
				// =======================================
			};
		},
		methods: {
			load() {
				let self = this;
				if (this.pagina > this.cuenta) {
					this.pagina = this.cuenta;
				}

				if (this.pagina === 0) {
					this.pagina = 1;
				}
				gen_rpost(controller + "obtenerCRMs", {
					pagina: this.pagina - 1,
					texto: this.texto,
				})
					.then((results) => {
						self.registros = results.CRMS.map(
							({ id, Nombre, Cliente }) => ({
								Nombre,
								id,
								Cliente: Cliente.Nombre,
							})
						);
						self.cuenta = Math.floor(+results.Cuenta / 15 + 1);
						if (results.Cuenta % 15 == 0) {
							self.cuenta--;
						}
						self.loading = false;
					})
					.catch((err) => {
						console.log(err);
					});
			},
			sendData(url, toggle) {
				let self = this;
				handled_rpost(`${controller}${url}`, {
					Nombre: this.one.nombre,
					Color: this.one.color,
					id: this.one.id,
					OcultarInfo: "" + this.one.ocultarInfo,
				})
					.then((res) => {
						// TODO: Revisar por que se hace esto
						// if (self.pagina === 0) {
						// 	window.location.reload();
						// }
						self.toggle(toggle);
						self.load();
					})
					.catch((err) => console.log(err));
			},
			add(url, toggle) {
				this.sendData(url, toggle);
			},
			edit($evt) {
				let self = this;
				gen_rpost(controller + "obtenerCRM", {
					id: $evt.id,
				})
					.then((res) => {
						let { id, Nombre, Color, OcultarInfo } = res.CRM;
						self.one = {
							nombre: Nombre,
							color: Color,
							id: id,
							ocultarInfo: OcultarInfo
						};

						self.toggle("edit");
					})
					.catch((err) => console.log(err));
			},
			del($evt) {
				let self = this;
				conf_rpost(
					controller + "eliminarCRM",
					{
						id: $evt.id,
					},
					traducirFrase("Continuar esta accion eliminara el CRM seleccionado")
				)
					.then((result) => {
						self.load();
					})
					.catch((err) => {
						console.log(err);
					});
			},
			toggle(target) {
				if (target == "add") {
					this.one = {
						nombre: "",
						color: "",
						id: "",
						ocultarInfo: false,
					};
				}
				app.targets[target] = !app.targets[target];
			},
			// =======================================================
			// Partes necesarias para los campos del CRM
			fields($evt) {
				const self = this;
				this.crmOrigen = $evt.id;
				this.campos = [];
				this.campoOriginal = {};
				this.seleccionarCategorias();
				gen_rpost(controller + "obtenerCamposCRM", {
					id: $evt.id,
				}).then((res) => {
					self.campos = res.Campos.map(
						({
							id,
							Nombre,
							Valor,
							Tipo,
							Edicion,
							Busqueda,
							Categoria,
							Requerido,
						}) => {
							let opciones = [];
							let valor = Valor;
							if (Tipo === 3) {
								const objValor = JSON.parse(Valor)
								Object.keys(objValor).forEach(key => {
									opciones.push({
										value: objValor[key],
										label: key
									})
								})
								valor = "";
							}

							return {
								id,
								Nombre,
								Tipo,
								Edicion,
								Busqueda,
								Requerido,
								Valor: valor,
								Categoria: Categoria.id,
								EnEdicion: false,
								Opciones: opciones,
							}
						}
					);
					self.modalCamposCRM = true;
				});
			},
			agregarCampo() {
				const nuevoCampo = {
					id: -1,
					Nombre: "",
					Valor: "",
					Tipo: 2,
					Edicion: 0,
					Categoria: -1,
					Busqueda: false,
					Requerido: false,
					EnEdicion: true,
					Opciones: [],
				};
				this.campos.push(nuevoCampo);
				this.campoOriginal[`${this.campos.length - 1}`] = nuevoCampo;
				console.log(this.campos, this.campoOriginal);
			},
			guardarCampo(num_index) {
				const campo = this.campos[num_index];
				let valorCampo = campo.Valor
				if (campo.Tipo === 3) {
					valorCampo = {}
					campo.Opciones.forEach(opcion => {
						valorCampo[opcion.label] = opcion.value
					});
					valorCampo = JSON.stringify(valorCampo)
				}
				if (campo.id === -1) {
					handled_rpost(
						`${controller}agregarCampo`,
						Object.assign(campo, {
							Valor: valorCampo
						})
					)
						.then((r) => {
							campo.id = r.Campo.id;
							campo.EnEdicion = false;
							delete campoOriginal[`${num_index}`];
						})
						.catch(console.log);
				} else {
					handled_rpost(
						`${controller}editarCampo`,
						Object.assign(campo, {
							Valor: valorCampo
						})
					)
						.then((r) => {
							console.log(r);
							campo.EnEdicion = false;
							delete campoOriginal[`${num_index}`];
						})
						.catch(console.log);
				}
				delete this.campoOriginal[`${num_index}`];
			},
			eliminarCampo(num_index) {
				const campo = this.campos[num_index];
				if (campo.id === -1) {
					const finalCampos = [];
					for (let i = 0; i < this.campos.length; i++)
						if (i !== num_index) finalCampos.push(this.campos[i]);
					this.campos = finalCampos;
				} else {
					const self = this;
					handled_rpost(`${controller}eliminarCampo`, campo)
						.then((r) => {
							const finalCampos = [];
							for (let i = 0; i < self.campos.length; i++)
								if (i !== num_index)
									finalCampos.push(self.campos[i]);
							self.campos = finalCampos;
						})
						.catch(console.log);
				}
			},
			editarCampo(num_index) {
				const campo = this.campos[num_index];
				campo.EnEdicion = true;
				this.campoOriginal[`${num_index}`] = Object.assign({}, campo);
			},
			cancelarEdicionCampo(num_index) {
				const campo = this.campos[num_index];
				if (campo.id === -1) this.eliminarCampo(num_index);
				else Object.assign(campo, this.campoOriginal[`${num_index}`]);
				campo.EnEdicion = false;
				delete this.campoOriginal[`${num_index}`];
			},
			seleccionarCategorias() {
				let self = this;
				handled_rpost(controller + "obtenerCategorias", {
					crm: this.crmOrigen,
				})
					.then((res) => {
						self.selectCategorias = res.Categorias.map(
							(categoria) => ({
								value: categoria.id,
								label: categoria.Nombre,
							})
						);
					})
					.catch((err) => {
						console.log(err);
					});
			},
			agregarOpcionACampo(num_index) {
				const campo = this.campos[num_index];
				campo.Opciones.push({
					value: "campo" + (campo.Opciones.length + 1),
					label: "Campo " + (campo.Opciones.length + 1),
				});
			},
			eliminarOpcionACampo(campo_index, opcion_index) {
				const campo = this.campos[campo_index]
				campo.Opciones = campo.Opciones.filter((_, i) => i !== opcion_index)
			},
			// =======================================================
			// Partes necesarias para las categorias del CRM
			categories($evt) {
				this.modalCategoriasCRM = true;
				this.crmOrigen = $evt.id;
				this.editandoCategoria = false;
				this.categorias = [];
				this.categoriaEnEdicion = {
					id: -1,
					crm: this.crmOrigen,
					Nombre: "",
					Posicion: 0,
					Contraido: false,
				};
				this.listarCategorias();
			},
			listarCategorias() {
				const self = this;
				gen_rpost(controller + "obtenerCategorias", {
					crm: this.crmOrigen,
				}).then((res) => {
					self.categorias = res.Categorias.map(
						({ id, Nombre, Posicion, Contraido }) => ({
							id,
							Nombre,
							Posicion,
							Contraido: Contraido == 1 ? true : false,
							crm: this.crmOrigen,
						})
					);
					self.modalCategoriasCRM = true;
				});
			},
			agregarCategoria() {
				this.editandoCategoria = true;
				this.categoriaEnEdicion = {
					id: -1,
					crm: this.crmOrigen,
					Nombre: "",
					Posicion: 0,
					Contraido: false,
				};
			},
			guardarCategoria() {
				const self = this;
				this.categoriaEnEdicion.Contraido = this.categoriaEnEdicion
					.Contraido
					? 1
					: 0;
				if (this.categoriaEnEdicion.id === -1) {
					handled_rpost(
						`${controller}agregarCategoria`,
						this.categoriaEnEdicion
					)
						.then((r) => {
							self.limpiarEstadoCategoria();
						})
						.catch(console.log);
				} else {
					handled_rpost(
						`${controller}editarCategoria`,
						this.categoriaEnEdicion
					)
						.then((r) => {
							self.limpiarEstadoCategoria();
						})
						.catch(console.log);
				}
			},
			eliminarCategoria($evt) {
				const categoria = $evt;
				const self = this;
				handled_rpost(`${controller}eliminarCategoria`, categoria)
					.then((r) => self.listarCategorias())
					.catch(console.log);
			},
			editarCategoria($evt) {
				const categoria = $evt;
				this.categoriaEnEdicion = categoria;
				this.editandoCategoria = true;
			},
			cancelarEdicionCategoria() {
				const categoria = this.categorias[this.indexCategoriaEnEdicion];
				if (categoria && categoria.id !== -1)
					Object.assign(categoria, this.categoriaEnEdicion);
				this.categoriaEnEdicion = {
					id: -1,
					crm: this.crmOrigen,
					Nombre: "",
					Posicion: 0,
					Contraido: false,
				};
				this.limpiarEstadoCategoria();
			},
			limpiarEstadoCategoria() {
				this.editandoCategoria = false;
				this.indexCategoriaEnEdicion = -1;
				this.categoriaEnEdicion = {
					id: -1,
					crm: this.crmOrigen,
					Nombre: "",
					Posicion: 0,
					Contraido: false,
				};
				this.listarCategorias();
			},
			// =======================================================
			// =======================================================
			// Funciones para los tipos de datos de los campos

			// =======================================================
		},
		computed: {
			validForm() {
				return this.one.nombre != "";
			},
		},
		watch: {
			pagina() {
				this.loading = true;
				this.load();
			},
		},
		updated() {
			$(".tooltipped").tooltip();
		},
		mounted() {
			$("select").formSelect();
			let self = this;
			setInterval(self.load, 2000);
		},
	});

	app.load();
})();
