let vue_obj;
(function () {
	const controlador = 'Voz';
	const app = new Vue({
		el: '#main',
		data() {
			return {
				// Variables para la tabla
				registros: [],
				loading: true,
				headers: [
					{ label: 'ID', key: 'id_voz' },
					{ label: traducirFrase('Nombre'), key: 'nombre' },
					// { label: 'Cliente', key: "Cliente" },
				],
				options: [
					{
						action: 'assoc',
						tooltip: traducirFrase('Asignar a clientes'),
						icon: 'edit',
					},
					{
						action: 'delete',
						tooltip: traducirFrase('Eliminar voz'),
						icon: 'delete',
					},
				],
				// Variables para los modales
				targets: {
					add: false,
					assoc: false,
				},
				// Registrar
				one: {
					id_voz: '',
					nombre: '',
				},
				// Editar
				// Paginacion
				pagina: 1,
				cuenta: 1,
				texto: '',

				// Variables para la asociacion de clientes
				clientes: [],
				id_voz: '',
				clientesAsociados: [],
				assocCliente: '',
				headersAssoc: [
					{ label: traducirFrase('Nombre'), key: 'nombre' },
				],
				optionsAssoc: [
					{
						action: 'delete',
						tooltip: traducirFrase('Quitar voz'),
						icon: 'delete',
					},
				],
			};
		},
		methods: {
			load() {
				let self = this;
				gen_rpost(controlador + '/getVoz', {
					pagina: this.pagina,
					texto: this.texto,
				})
					.then((results) => {
						self.registros = results.Registros;
						self.cuenta = Math.floor(+results.Cant / 15 + 1);
						if (results.Cant % 15 == 0) {
							self.cuenta--;
						}
						self.loading = false;
					})
					.catch((err) => {
						console.log(err);
					});
			},
			sendData(url, toggle) {
				let self = this;
				handled_rpost(`${controlador}/${url}`, {
					nombre: this.one.nombre,
					id_voz: this.one.id_voz,
				})
					.then((res) => {
						self.toggle(toggle);
						self.load();
					})
					.catch((err) => console.log(err));
			},
			add(url, toggle) {
				this.sendData(url, toggle);
			},
			assoc($evt) {
				let self = this;
				gen_rpost('Clientes/getClientsSelect', {})
					.then((res) => {
						// TODO: Cambiar url para obtener asociados
						gen_rpost('Clientes/getClientsSelect', {
							id_voz: $evt.id_voz,
						})
							.then((resAssoc) => {
								self.id_voz = $evt.id_voz;
								self.clientes = res.Registros.map((v) => {
									return {
										value: v.nombre,
										label: v.nombre,
									};
								});
								self.clientesAsociados = resAssoc.Registros;
								self.toggle('assoc', true);
							})
							.catch((err) => console.log(err));
					})
					.catch((err) => console.log(err));
			},
			del($evt) {
				let self = this;
				conf_rpost(
					controlador + '/deleteVoz',
					{
						id_voz: $evt.id_voz,
					},
					traducirFrase(
						'Continuar esta accion eliminara la voz seleccionada'
					)
				)
					.then((result) => {
						self.load();
					})
					.catch((err) => {
						console.log(err);
					});
			},
			addAssoc() {
				let self = this;
				handled_rpost(`Clientes/assocVozClient`, {
					cliente: this.assocCliente,
					id_voz: this.id_voz,
				})
					.then((res) => {
						self.assocCliente = '';
						self.assoc({
							id_voz: self.id_voz,
						});
					})
					.catch((err) => console.log(err));
			},
			deleteAssoc(evt) {
				let self = this;
				// TODO: cambiar a peticion de eliminar voz a cliente
				conf_rpost(
					'Clientes/deleteVoz',
					{
						id_voz: $evt.id_voz,
					},
					traducirFrase(
						'Continuar esta accion eliminara la voz al cliente seleccionado'
					)
				)
					.then((result) => {
						self.assoc({
							id_voz: self.id_voz,
						});
					})
					.catch((err) => {
						console.log(err);
					});
			},
			toggle(target, value) {
				if (target == 'add') {
					this.one = {
						nombre: '',
						id_voz: '',
					};
				}
				app.targets[target] = value ? value : !app.targets[target];
			},
		},
		computed: {
			validForm() {
				return this.one.nombre !== '' && this.one.id_voz !== '';
			},
		},
		watch: {
			pagina() {
				this.load();
			},
		},
		updated() {
			$('.tooltipped').tooltip();
		},
		mounted() {
			let self = this;
			this.load();
			setInterval(self.load, 20000);
		},
	});

	app.load();
	vue_obj = app;
})();
