(function () {
	const defaultOptions = [{ value: '-1', label: traducirFrase('Selecciona una campaña') }];
	const defaultHeaders = [
		{ label: traducirFrase('Usuario'), key: 'nombre' },
	]

	const app = new Vue({
		el: '#main',
		data() {
			return {
				campana: '-1',
				options: defaultOptions,
				registros: [],
				headers: defaultHeaders,
				archived: false,
			};
		},
		methods: {
			getFecha() {
				return $('#fechaReporte').val().split(' - ');
			},
			load() {
				const [fechaInicio, fechaFin] = this.getFecha();
				document.getElementById('spinner').style.display = 'block';
				rget('ReportePausaCampa/pauseReport', {
					fechaInicial: fechaInicio,
					fechaFinal: fechaFin ? fechaFin : fechaInicio,
					archived: this.archived ? 1 : 0,
					campana: this.campana,
				})
					.then((r) => {
						gen_rpost('Campanas/getCampaignsSelect', {})
							.then((rcamp) => {
								this.options = [
									...defaultOptions,
									...rcamp.Campanas.map((v) => ({
										value: v.campaign_id,
										label: v.campaign_name,
									})),
								];

								const registros = r.Registros;

								const headers = {};

								this.registros = Object.keys(registros).map(
									(key) => {
										const registro = registros[key];
										const status = registro.status;

										const r = {
											usuario: key,
											nombre: registro.full_name
												? registro.full_name
												: key,
										};

										Object.keys(status).forEach(key => {
											r[key] = status[key].tiempoPausa
											if (
												!headers[key]
											) {
												headers[key] = {
													label: key,
													key: key
												}
											}
										})

										return r
									}
								);

								this.headers = [
									...defaultHeaders,
									...Object.values(headers)
								]

								this.headers.forEach(h => {
									this.registros.forEach(r => {
										if (!r[h.key]) {
											r[h.key] = "00:00:00"
										}
									})
								})

								document.getElementById(
									'spinner'
								).style.display = 'none';
							})
							.catch(console.log);
					})
					.catch(console.log);
			},
			descargar() {
				const [fechaInicio, fechaFin] = this.getFecha();
				window.location.href = `${DV_MODULOS}/ReportePausaCampa/pauseReport?fechaInicial=${fechaInicio}&fechaFinal=${fechaFin ? fechaFin : fechaInicio
					}&archived=${this.archived ? 1 : 0}&campana=${this.campana
					}&csv=1`;
			},
		},
		updated() {
			$('.tooltipped').tooltip();
		},
		mounted() {
			$('#fechaReporte').val(new Date().toISOString().split('T').shift());
			this.load();
		},
	});
})();
