<?php include UTILS_PATH . "components" . DIRECTORY_SEPARATOR . "table.component.php";?>
<?php include UTILS_PATH . "requests.php";?>
<script>
	const app = new Vue({
		el: "#main",
		data() {
			return {
				filtroGrupo: [],
				selectGrupos: [],
				grupos: [],
				headers: [
					{ label: traducirFrase("Hora"), key: "hora" },
					{ label: traducirFrase("Total llamadas"), key: "totalLlamadas" },
					{ label: traducirFrase("Total contestadas"), key: "totalContestadas" },
					{ label: traducirFrase("Tiempo total en llamada"), key: "tiempoCharla" },
					{ label: traducirFrase("Promedio de tiempo en llamada"), key: "promedioLlamada" },
					{ label: traducirFrase("Tiempo total en espera"), key: "tiempoCola" },
					{ label: traducirFrase("Tiempo promedio en espera"), key: "promedioCola" },
					{ label: traducirFrase("Maximo tiempo en espera"), key: "maximoCola" },
					{ label: traducirFrase("Total de llamadas abandonadas"), key: "totalAbandonados" },
				],
				tipoVisualizacion: "normal",
				totales: []
			}
		},
		methods: {
			generaReporte(grupos) {
				this.obtenerSelectGrupos()
				this.grupos = grupos.map(grupo => {

					const campos = Object.keys(grupo).filter(key => key !== "grupo")
					const registros = []

					for (let i = 0; i < 24; i++) {
						const tmp_obj = {
							hora: i
						}

						campos.forEach(campo => {
							if (["tiempoCharla", "promedioLlamada", "tiempoCola", "promedioCola", "maximoCola"].find(item => item === campo)) {
								const dt = new Date(0)
								dt.setUTCSeconds(grupo[campo][i])
								tmp_obj[campo] = dt.toISOString().split("T").pop().split(".").shift()
							} else {
								tmp_obj[campo] = grupo[campo][i]
							}
						})

						registros.push(tmp_obj)
					}

					return {
						nombre: grupo.grupo,
						registros: registros
					}
				})
			},
			async obtenerSelectGrupos() {
				try {
					const r = await gen_rpost("GrupoDeEntrada/seleccionarIngroups", {})
					this.selectGrupos = r.Ingroups.map(ingroup => ({
						label: ingroup.Nombre,
						value: ingroup.id
					}))
					setTimeout(() => $("#select-ingroups").formSelect(), 500)
				} catch(e) {
					console.error(e)
				}
			}
		},
		watch: {
			tipoVisualizacion() {
				if (this.tipoVisualizacion === "normal") {

					const fechasR = $("#pickDate").val().split(" - ")

					const params = {
						csv: true,
						fechaInicio: fechasR[0],
						fechaFin: fechasR[1] ? fechasR[1] : fechasR[0],
						grupos: app.filtroGrupo,
						archived: document.getElementById("archived").checked ? "1" : "0",
					}
					$("#descargarBoton").attr("href","<?=MODULOS;?>reporteHora/summaryHourly?"+$.param(params));
				} else {
					$("#descargarBoton").attr("href","javascript:descargarDesglosePorHoras();");
				}
			},
			filtroGrupo() {
				if (this.tipoVisualizacion === "normal") {
					const fechasR = $("#pickDate").val().split(" - ")

					const params = {
						csv: true,
						fechaInicio: fechasR[0],
						fechaFin: fechasR[1] ? fechasR[1] : fechasR[0],
						grupos: app.filtroGrupo,
						archived: document.getElementById("archived").checked ? "1" : "0",
					}
					$("#descargarBoton").attr("href","<?=MODULOS;?>reporteHora/summaryHourly?"+$.param(params));
				} else {
					$("#descargarBoton").attr("href","javascript:descargarDesglosePorHoras();");
				}
			}
		},
		computed: {
			gruposFiltrados() {
				if (this.filtroGrupo.length === 0) {
					return this.grupos
				} else {
					return this.grupos.filter(grupo => {
						const og_grupo = this.selectGrupos.find(v => v.label === grupo.nombre)
						return Boolean(
							this.filtroGrupo.find(v => v === og_grupo.value)
						)
					})
				}
			}
		},
		mounted: function() {
			setTimeout(() => {
				const fechasR = $("#pickDate").val().split(" - ")
			
				const params = {
					csv: true,
					fechaInicio: fechasR[0],
					fechaFin: fechasR[1] ? fechasR[1] : fechasR[0],
					grupos: app.filtroGrupo,
					archived: document.getElementById("archived").checked ? "1" : "0",
				}
				$("#descargarBoton").attr("href","<?=MODULOS;?>reporteHora/summaryHourly?"+$.param(params));
			}, 500)
		}
	})
	var a = document.getElementById('idioma');
              if(a.value == "es"){
                <?php if (defined("BANDERA_ES")) {?>
					document.getElementById('banderaPais').innerHTML = '<span class="flag-icon flag-icon-<?php echo BANDERA_ES; ?>"></span>&nbsp;';
				<?php } else {?>
					document.getElementById('banderaPais').innerHTML = '<span class="flag-icon flag-icon-mx"></span>&nbsp;';
				<?php }?>

              }else{

                document.getElementById('banderaPais').innerHTML = '<span class="flag-icon flag-icon-um"></span>&nbsp;';

              }

	if (localStorage.getItem('background') == "black") {
		document.getElementById('stemen').style.filter = 'invert(100%)'
	}
var flagPeticion=false;
var Inicial=true;

	function descargarDesglosePorHoras() {
		const content = [[traducirFrase("Grupo de entrada"),...app.headers.map(header => header.label)]]
		app.totales.forEach(reg => {
			const arr = []
			arr.push("Acumulado")
			app.headers.forEach(header => {
				arr.push(reg[header.key])
			})
			content.push(arr)
		})
		app.gruposFiltrados.forEach(grupo => {
			grupo.registros.forEach(reg => {
				const arr = []
				arr.push(grupo.nombre)
				app.headers.forEach(header => {
					arr.push(reg[header.key])
				})
				content.push(arr)
			})
		})
		let csvcontent = "data:text/csv;charset=utf-8,";
		csvcontent += content.map(r => r.join(",")).join("\n");

		const encodeuri = encodeURI(csvcontent);
		const link = document.createElement("a");
		link.setAttribute("href", encodeuri);
		link.setAttribute("download", "ReporteEntrantePorHora-"+(new Date()).getTime()+".csv");
		document.body.appendChild(link)

		link.click()
		link.remove()
	}

function dIni(date){
		return date.slice(0,10);
	}

	function dEnd(date){

		var fecF = date.slice(13,23);

		if(fecF == ""){

			fecF = date.slice(0,10);
		}

		return fecF;
	}

	$(document).ready(function () {
        var today = new Date();
		var dd = today.getDate();
		var mm = today.getMonth() + 1; //January is 0!
		var yyyy = today.getFullYear();
		if (dd < 10) {
		dd = '0' + dd;
		}
		if (mm < 10) {
		mm = '0' + mm;
		}
		var today = yyyy+ '-' + mm + '-' + dd;
		$('#pickDate').val(today+" - "+today);

		cargaPeticion();
	});

function cargaPeticion()
{
	if(!flagPeticion)
	{

		flagPeticion=true;

		const fechasR = $("#pickDate").val().split(" - ")

		var parametros={
			fechaInicio: fechasR[0],
			fechaFin: fechasR[1] ? fechasR[1] : fechasR[0],
			archived: document.getElementById("archived").checked ? "1" : "0",
			grupos: app.filtroGrupo,
		};
		$("#idtbody").html("");
		$.ajax({
			url: "<?=MODULOS;?>reporteHora/summaryHourly",
			type: "GET",
			dataType: "text",
			data : parametros,
			success: function (result) {

				if (app.tipoVisualizacion === "normal") {
					const fechasR = $("#pickDate").val().split(" - ")
					const params = {
						csv: true,
						fechaInicio: fechasR[0],
						fechaFin: fechasR[1] ? fechasR[1] : fechasR[0],
						grupos: app.filtroGrupo,
						archived: document.getElementById("archived").checked ? "1" : "0",
					}
					$("#descargarBoton").attr("href","<?=MODULOS;?>reporteHora/summaryHourly?"+$.param(params));
				} else {
					$("#descargarBoton").attr("href","javascript:descargarDesglosePorHoras();");
				}

				var res = JSON.parse(result);
				if(res.Estado=='ok')
				{
					$("#idtbody").html("");
					if(res.general==null)
					{
						res.general=[];
					}

					app.generaReporte(res.Grupos)

					// INICIO - Generar registros para tabla totales
					/*
						{ label: "Hora", key: "hora" },
						{ label: "Total llamadas", key: "totalLlamadas" },
						{ label: "Total contestadas", key: "totalContestadas" },
						{ label: "Tiempo total en llamada", key: "tiempoCharla" },
						{ label: "Promedio de tiempo en llamada", key: "promedioLlamada" },
						{ label: "Tiempo total en espera", key: "tiempoCola" },
						{ label: "Tiempo promedio en espera", key: "promedioCola" },
						{ label: "Maximo tiempo en espera", key: "maximoCola" },
						{ label: "Total de llamadas abandonadas", key: "totalAbandonados" },
					*/
					const registrosTotales = []

					for (let i = 0; i < 24; i++) {
						const tmp_obj = {
							hora: i
						}

						Object.keys(res.Totales).forEach(campo => {
							if (["tiempoCharla", "promedioLlamada", "tiempoCola", "promedioCola", "maximoCola"].find(item => item === campo)) {
								const dt = new Date(0)
								dt.setUTCSeconds(res.Totales[campo][i])
								tmp_obj[campo] = dt.toISOString().split("T").pop().split(".").shift()
							} else {
								tmp_obj[campo] = res.Totales[campo][i]
							}
						})

						registrosTotales.push(tmp_obj)
					}

					app.totales = registrosTotales
					// FIN - Generar registros para tabla totales

					var dataE = [];

					for(var i=0;i<res.general.length;i++)
					{
						if(res.general[i].totalLlamada==null)
						{
							res.general[i].totalLlamada=0;
						}
						res.general[i].totalLlamada = parseFloat(res.general[i].totalLlamada);
						var Horas = Math.floor(res.general[i].totalLlamada / 3600);
						res.general[i].totalLlamada -= Horas * 3600;
						var Minutos = Math.floor(res.general[i].totalLlamada/ 60);
						res.general[i].totalLlamada -= Minutos * 60;
						var Segundos = Math.floor(res.general[i].totalLlamada);
						res.general[i].totalLlamada =(Horas<10?"0"+Horas:Horas) + ":" + (Minutos<10?"0"+Minutos:Minutos) + ":" + (Segundos<10?"0"+Segundos:Segundos);

						if(res.general[i].promedioLlamada==null)
						{
							res.general[i].promedioLlamada=0;
						}
						res.general[i].promedioLlamada = parseFloat(res.general[i].promedioLlamada);
						Horas = Math.floor(res.general[i].promedioLlamada / 3600);
						res.general[i].promedioLlamada -= Horas * 3600;
						Minutos = Math.floor(res.general[i].promedioLlamada/ 60);
						res.general[i].promedioLlamada -= Minutos * 60;
						Segundos = Math.floor(res.general[i].promedioLlamada);
						res.general[i].promedioLlamada =(Horas<10?"0"+Horas:Horas) + ":" + (Minutos<10?"0"+Minutos:Minutos) + ":" + (Segundos<10?"0"+Segundos:Segundos);

						if(res.general[i].totalCola==null)
						{
							res.general[i].totalCola=0;
						}
						res.general[i].totalCola = parseFloat(res.general[i].totalCola);
						Horas = Math.floor(res.general[i].totalCola / 3600);
						res.general[i].totalCola -= Horas * 3600;
						Minutos = Math.floor(res.general[i].totalCola/ 60);
						res.general[i].totalCola -= Minutos * 60;
						Segundos = Math.floor(res.general[i].totalCola);
						res.general[i].totalCola =(Horas<10?"0"+Horas:Horas) + ":" + (Minutos<10?"0"+Minutos:Minutos) + ":" + (Segundos<10?"0"+Segundos:Segundos);

						if(res.general[i].promedioCola==null)
						{
							res.general[i].promedioCola=0;
						}
						res.general[i].promedioCola = parseFloat(res.general[i].promedioCola);
						Horas = Math.floor(res.general[i].promedioCola / 3600);
						res.general[i].promedioCola -= Horas * 3600;
						Minutos = Math.floor(res.general[i].promedioCola/ 60);
						res.general[i].promedioCola -= Minutos * 60;
						Segundos = Math.floor(res.general[i].promedioCola);
						res.general[i].promedioCola =(Horas<10?"0"+Horas:Horas) + ":" + (Minutos<10?"0"+Minutos:Minutos) + ":" + (Segundos<10?"0"+Segundos:Segundos);

						if(res.general[i].maximoCola==null)
						{
							res.general[i].maximoCola=0;
						}
						res.general[i].maximoCola = parseFloat(res.general[i].maximoCola);
						Horas = Math.floor(res.general[i].maximoCola / 3600);
						res.general[i].maximoCola -= Horas * 3600;
						Minutos = Math.floor(res.general[i].maximoCola/ 60);
						res.general[i].maximoCola -= Minutos * 60;
						Segundos = Math.floor(res.general[i].maximoCola);
						res.general[i].maximoCola =(Horas<10?"0"+Horas:Horas) + ":" + (Minutos<10?"0"+Minutos:Minutos) + ":" + (Segundos<10?"0"+Segundos:Segundos);

						$("#idtbody").append("<tr><td nowrap>"+res.general[i].grupo+"</td><td>"+res.general[i].totalLlamadas+"</td><td>"+res.general[i].totalContestadas+"</td><td>"+res.general[i].totalLlamada+"</td><td>"+res.general[i].promedioLlamada+"</td><td>"+res.general[i].totalCola+"</td><td>"+res.general[i].promedioCola+"</td><td>"+res.general[i].maximoCola+"</td><td>"+res.general[i].totalAbandono+"</td></tr>");


						dataE.push({
							name : res.general[i].grupo,
							y: parseInt(res.general[i].totalLlamadas)
							//numRand
						});

					}

					creaColumnas4(dataE);

					if(res.total.totalLlamada==null)
					{
						res.total.totalLlamada=0;
					}
					res.total.totalLlamada = parseFloat(res.total.totalLlamada);
					var Horas = Math.floor(res.total.totalLlamada / 3600);
					res.total.totalLlamada -= Horas * 3600;
					var Minutos = Math.floor(res.total.totalLlamada/ 60);
					res.total.totalLlamada -= Minutos * 60;
					var Segundos = Math.floor(res.total.totalLlamada);
					res.total.totalLlamada =(Horas<10?"0"+Horas:Horas) + ":" + (Minutos<10?"0"+Minutos:Minutos) + ":" + (Segundos<10?"0"+Segundos:Segundos);

					if(res.total.totalCola==null)
					{
						res.total.totalCola=0;
					}
					res.total.totalCola = parseFloat(res.total.totalCola);
					Horas = Math.floor(res.total.totalCola / 3600);
					res.total.totalCola -= Horas * 3600;
					Minutos = Math.floor(res.total.totalCola/ 60);
					res.total.totalCola -= Minutos * 60;
					Segundos = Math.floor(res.total.totalCola);
					res.total.totalCola =(Horas<10?"0"+Horas:Horas) + ":" + (Minutos<10?"0"+Minutos:Minutos) + ":" + (Segundos<10?"0"+Segundos:Segundos);

					if(res.total.maximoCola==null)
					{
						res.total.maximoCola=0;
					}
					res.total.maximoCola = parseFloat(res.total.maximoCola);
					Horas = Math.floor(res.total.maximoCola / 3600);
					res.total.maximoCola -= Horas * 3600;
					Minutos = Math.floor(res.total.maximoCola/ 60);
					res.total.maximoCola -= Minutos * 60;
					Segundos = Math.floor(res.total.maximoCola);
					res.total.maximoCola =(Horas<10?"0"+Horas:Horas) + ":" + (Minutos<10?"0"+Minutos:Minutos) + ":" + (Segundos<10?"0"+Segundos:Segundos);

					if(res.total.promedioTiempoLlamada==null)
					{
						res.total.promedioTiempoLlamada=0;
					}
					res.total.promedioTiempoLlamada = parseFloat(res.total.promedioTiempoLlamada);
					Horas = Math.floor(res.total.promedioTiempoLlamada / 3600);
					res.total.promedioTiempoLlamada -= Horas * 3600;
					Minutos = Math.floor(res.total.promedioTiempoLlamada/ 60);
					res.total.promedioTiempoLlamada -= Minutos * 60;
					Segundos = Math.floor(res.total.promedioTiempoLlamada);
					res.total.promedioTiempoLlamada =(Horas<10?"0"+Horas:Horas) + ":" + (Minutos<10?"0"+Minutos:Minutos) + ":" + (Segundos<10?"0"+Segundos:Segundos);

					res.total.promedioTiempoColaEspera = parseFloat(res.total.promedioTiempoColaEspera);
					Horas = Math.floor(res.total.promedioTiempoColaEspera / 3600);
					res.total.promedioTiempoColaEspera -= Horas * 3600;
					Minutos = Math.floor(res.total.promedioTiempoColaEspera/ 60);
					res.total.promedioTiempoColaEspera -= Minutos * 60;
					Segundos = Math.floor(res.total.promedioTiempoColaEspera);
					res.total.promedioTiempoColaEspera =(Horas<10?"0"+Horas:Horas) + ":" + (Minutos<10?"0"+Minutos:Minutos) + ":" + (Segundos<10?"0"+Segundos:Segundos);
					$("#idtbody").append("<tr><td nowrap>"+traducirFrase("Total de grupos de entrada")+": "+res.general.length+"</td><td>"+res.total.totalLlamadas+"</td><td>"+res.total.totalContestadas+"</td><td>"+res.total.totalLlamada+"</td><td>"+res.total.promedioTiempoLlamada+"</td><td>"+res.total.totalCola+"</td><td>"+res.total.promedioTiempoColaEspera+"</td><td>"+res.total.maximoCola+"</td><td>"+res.total.totalAbandono+"</td></tr>");
					flagPeticion = false;
					var bla;

			function cambiarAOscuro() {

				for (let i = 0; i < bla.length; i++) {
					bla[i].classList.remove('white');
					bla[i].classList.add('grey');
					bla[i].classList.add('lighten-1');bla[i].style.filter = 'invert(100%)';
				}
			}

			if (localStorage.getItem('background') == "black") {
				bla = document.getElementsByClassName('card-panel')
				bla = Array.prototype.slice.call(bla)
				cambiarAOscuro();
			}
				}
				else
				{
					M.toast({html:res.Descripcion});
				}
			},
			error: function (error) {
				console.log(error);
			}
		});
	}
}

	function creaPie1(dataE){

		/*Highcharts.chart('highChart5', {
			chart: {
				type: 'pie',
				options3d: {
					enabled: true,
					alpha: 45,
					beta: 0
				}
			},
			title: {
				text: ' '
			},
			tooltip: {
				pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
			},
			plotOptions: {
				pie: {
					allowPointSelect: true,
					cursor: 'pointer',
					depth: 35,
					dataLabels: {
						enabled: true,
						format: '{point.name}'
					}
				}
			},
			series: [{
				type: 'pie',
				name: 'Porcentaje',
				data: dataE
			}]
		});*/



	}

	function creaColumnas4(dataE){

		var dataE2 = [];
		var dataL = [];
		var dataC = [];

		var colorW = "";

		console.log(dataE);
		//return;

		var lab = ['0','5','10','15','20','30','35','40','45','50','55','60','90','90+'];

		var ii = 0;

		$.each(dataE, function( index, value ) {

			colorW = generaColor();

			dataC.push(
				colorW
			);

			dataL.push(dataE.name);

			colorW = generaColor();

			dataC.push(
				colorW
			);

		});

		/*Highcharts.chart('highChart5', {
			chart: {
				type: 'column'
			},
			title: {
				text: 'Reporte por Hora'
			},
			colors:dataC,
			xAxis: {
				min: 0,
				max:5,
				scrollbar: {
					enabled: true
				},
				labels: {
					skew3d: true,
					style: {
						fontSize: '16px'
					}
				}
			},
			yAxis: {
				title: {
					text: null
				}
			},
			series: [{
				name: 'Llamadas',
				data: dataE
			}]
		});*/

		Highcharts.chart('highChart5', {

			chart: {
				polar: true,
				type: 'line'
			},

			accessibility: {
				description: ''
			},

			title: {
				text: traducirFrase('Reporte por hora'),
				x: -80
			},

			pane: {
				size: '80%'
			},

			xAxis: {
				categories: dataL,
				tickmarkPlacement: 'on',
				lineWidth: 0
			},

			yAxis: {
				gridLineInterpolation: 'polygon',
				lineWidth: 0,
				min: 0
			},

			tooltip: {
				shared: true,
				pointFormat: '<span style="color:{series.color}">{series.name}: <b>${point.y:,.0f}</b><br/>'
			},

			legend: {
				align: 'right',
				verticalAlign: 'middle'
			},

			series: [{
				name: traducirFrase('Llamadas'),
				data: dataE,
				pointPlacement: 'on'
			}],

			responsive: {
				rules: [{
					condition: {
						maxWidth: 500
					},
					chartOptions: {
						legend: {
							align: 'center',
							verticalAlign: 'bottom'
						},
						pane: {
							size: '70%'
						}
					}
				}]
			}

		});

	}

	function generaColor(){

		var hexadecimal = new Array("0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F");
		var color_aleatorio = "#";

		var posarray;

		for (i=0;i<6;i++){

			posarray = aleatorio(0,hexadecimal.length);
			color_aleatorio += hexadecimal[posarray];

		}

		return color_aleatorio
	}

	function aleatorio(inferior,superior){
		numPosibilidades = superior - inferior;
		aleat = Math.random() * numPosibilidades;
		aleat = Math.floor(aleat);

		return parseInt(inferior) + aleat;
	}

</script>