(function () {
	const app = new Vue({
		el: '#main',
		data() {
			return {
				encuestas: [],
				encuesta: '',
				loading: false,
				sunburstChart: null,
				hideInvalidAnswer: true,
				campanas: [],
				campana: [],
			};
		},
		methods: {
			getFecha() {
				return $('#fecha').val().split(' - ');
			},
			load() {
				const self = this;
				const [fechaInicio, fechaFin] = this.getFecha();
				this.loading = true;
				rpost('ReporteEncuestas/reporteGeneral', {
					json: true,
					fechaInicio,
					fechaFin: fechaFin ? fechaFin : fechaInicio,
					encuesta: this.encuesta,
					campanas: this.campana.join(","),
				})
					.then((r) => {
						self.loading = false;
						self.obtenerEncuestas();
						if (self.sunburstChart) {
							self.sunburstChart.dispose();
							self.sunburstChart = null;
						}
						self.sunburstChart = self.generarSunburst(r.Cuenta);
					})
					.catch(console.log);
			},
			descargar() {
				const [fechaInicio, fechaFin] = this.getFecha();
				let url = 'ReporteEncuestas/reporteGeneral';
				let request = new XMLHttpRequest();
				request.responseType = 'blob';
				request.open('POST', url, true);
				let parametros = {
					fechaInicio,
					fechaFin: fechaFin ? fechaFin : fechaInicio,
					encuesta: this.encuesta,
					campanas: this.campana.join(","),
				};
				let urlEncodedData = '',
					name;
				for (name in parametros) {
					urlEncodedData +=
						encodeURIComponent(name) +
						'=' +
						encodeURIComponent(parametros[name]) +
						'&';
				}
				if (urlEncodedData.charAt(urlEncodedData.length - 1) == '&') {
					urlEncodedData = urlEncodedData.substring(
						0,
						urlEncodedData.length - 1
					);
				}
				request.setRequestHeader(
					'Content-type',
					'application/x-www-form-urlencoded'
				);
				request.send(urlEncodedData);
				request.onreadystatechange = function () {
					if (this.readyState == 4 && this.status == 200) {
						let respuestaRecibida = this.response;
						if (respuestaRecibida.type == 'application/json') {
							respuestaRecibida.text().then((text) => {
								let respuestaJSON = JSON.parse(text);
								console.log(respuestaJSON);
								M.toast({
									html: respuestaJSON,
								});
							});
						} else {
							const reporteURL =
								window.URL.createObjectURL(respuestaRecibida);
							const anchor = document.createElement('a');
							anchor.href = reporteURL;
							anchor.download =
								'Reporte general de la encuestade ' +
								fechaInicio +
								' a ' +
								(fechaFin ? fechaFin : fechaInicio) +
								'.csv';
							document.body.appendChild(anchor);
							anchor.click();
						}
					}
					if (this.readyState == 4 && this.status !== 200) {
						//Manejar el error de HTTP (error de PHP)
						M.toast({
							html: traducirFrase(
								'Hubo un error con el servidor'
							),
						});
					}
				};
				request.onprogress = function (e) {
					//Aqui es para que hagan una barra de progreso
				};
			},
			obtenerEncuestas(h) {
				const self = this;
				gen_rpost('Encuestas/getEncuestasSelect', {})
					.then((r) => {
						self.encuestas = r.Registros.map((v) => ({
							value: v.id_encuesta,
							label: v.nombre,
						}));
						if (self.encuesta === '') {
							self.encuesta = self.encuestas[0].value;
						}
						if (h) h();
					})
					.catch(console.log);
			},
			generarSunburst(d) {
				const self = this;
				const generaData = (data, i) => {
					const keys = Object.keys(data)
						.filter((k) => k !== '0')
						.filter((k) => {
							return self.hideInvalidAnswer
								? k === 'Respuesta invalida'
									? false
									: true
								: true;
						});

					return {
						name: {
							full: data['0'],
							short: 'P. #' + (i + 1),
						},
						children: keys.map((v, j) => ({
							name: {
								full: v,
								short: 'R. #' + (j + 1),
							},
							value: data[v],
						})),
					};
				};

				console.log(d.map(generaData))

				const root = am5.Root.new('dv-sunburst');
				root.locale = am5locales_es_ES;
				root.setThemes([
					am5themes_Animated.new(root),
					am5themes_Spirited.new(root),
				]);

				const container = root.container.children.push(
					am5.Container.new(root, {
						width: am5.percent(100),
						height: am5.percent(100),
						layout: root.verticalLayout,
					})
				);

				const series = container.children.push(
					am5hierarchy.Sunburst.new(root, {
						singleBranchOnly: true,
						downDepth: 10,
						initialDepth: 10,
						topDepth: 1,
						radius: am5.percent(80),
						innerRadius: am5.percent(10),
						valueField: 'value',
						categoryField: 'name',
						childDataField: 'children',
					})
				);

				series.labels.template.setAll({
					text: '[bold]{category.short}[/]',
				});

				series.nodes.template.setAll({
					tooltipText: '{category.full}: [bold]{sum}[/]',
				});

				series.data.setAll([
					{
						name: 'root',
						children: d.map(generaData),
					},
				]);

				series.selectDataItem(series.dataItems[0]);

				series.appear(1000, 100);

				return root;
			},
			selectCampanas(h) {
				const self = this
				gen_rpost("Campanas/getCampaignsSelect", {})
					.then((r) => {
						self.campanas = r.Campanas.map((campana) => ({
							value: campana.campaign_id,
							label: campana.campaign_name,
						}));
						setTimeout(() => {
							$('select').formSelect();
							if (h) h();
						}, 1000)
					})
					.catch(console.log);
			}
		},
		updated() {
			$('.tooltipped').tooltip();
		},
		mounted() {
			const self = this;
			const dini = new Date();
			const dfin = new Date();
			dini.setDate(dfin.getDate() - 5);
			$('#fecha').val(
				dini.toISOString().split('T').shift() +
					' - ' +
					dfin.toISOString().split('T').shift()
			);
			this.obtenerEncuestas((_) => {
				this.selectCampanas((_) => {
					self.load();
				});
			});
		},
	});
})();
