
(function () {

    const controller = "Telefono"

    const app = new Vue({
        el: "#main",
        data() {
            return {
                // Variables para la tabla
                registros: [],
                loading: true,
                headers: [
                    { label: traducirFrase('Extension'), key: "Extension" },
                    { label: traducirFrase('Nombre'), key: "Nombre" },
                    { label: traducirFrase('Protocolo'), key: "Protocolo" },
                ],
                options: [
                    { action: 'edit', tooltip: traducirFrase('Editar la extension'), icon: 'edit' },
                    { action: 'delete', tooltip: traducirFrase('Eliminar extension'), icon: 'delete' },
                ],
                // Variables para los modales
                targets: {
                    add: false,
                    edit: false,
                },
                // Registrar
                one: {
                    extension: '',
                    numeroPlanDeMarcacion: '',
                    voicemail: '',
                    identificadorSaliente: '',
                    usuario: '',
                    pass: '',
                    activa: false,
                    nombre: '',
                    protocolo: 'SIP',
                    tipoTelefono: '',
                },
                // Editar
                // Paginacion
                pagina: 1,
                cuenta: 1,
                texto: "",
            }
        },
        methods: {
            load() {
                let self = this
                if (this.pagina > this.cuenta) {
                    this.pagina = this.cuenta
                }
                gen_rpost(`${controller}/listarExtensiones`, {
                    pagina: this.pagina - 1,
                    texto: this.texto
                }).then(results => {
                    self.registros = results.Extensiones
                    self.cuenta = Math.floor((+results.Cuenta) / 15 + 1)
                    if (results.Cuenta % 15 == 0) {
                        self.cuenta--
                    }
                    self.loading = false
                }).catch(err => {
                    console.log(err)
                })
            },
            sendData(url, toggle) {
                let self = this
                handled_rpost(`${controller}/${url}`, {
                    extension: this.one.extension,
                    numeroPlanDeMarcacion: this.one.numeroPlanDeMarcacion,
                    voicemail: this.one.voicemail,
                    identificadorSaliente: this.one.identificadorSaliente,
                    usuario: this.one.usuario,
                    pass: this.one.pass,
                    activa: this.one.activa ? 'Y' : 'N',
                    nombre: this.one.nombre,
                    protocolo: this.one.protocolo,
                    tipoTelefono: this.one.tipoTelefono,
                }).then(res => {
                    if (self.pagina === 0) {
                        window.location.reload();
                    }
                    self.toggle(toggle)
                    self.pagina = 1
                    self.cuenta = 1
                    self.load()
                })
                    .catch(err => console.log(err))
            },
            add(url, toggle) {
                this.sendData(url, toggle)
            },
            edit($evt) {
                let self = this
                gen_rpost(`${controller}/obtenerExtension`, {
                    extension: $evt.Extension
                }).then(res => {
                    let {
                        Extension,
                        NumeroPlanDeMarcacion,
                        Voicemail,
                        IdentificadorSaliente,
                        Usuario,
                        Password,
                        Activa,
                        Nombre,
                        Protocolo,
                        TipoTelefono
                    } = res.Extension
                    self.one = {
                        extension: Extension,
                        numeroPlanDeMarcacion: NumeroPlanDeMarcacion,
                        voicemail: Voicemail,
                        identificadorSaliente: IdentificadorSaliente,
                        usuario: Usuario,
                        pass: Password,
                        activa: Activa == 'Y' ? true : false,
                        nombre: Nombre,
                        protocolo: Protocolo,
                        tipoTelefono: TipoTelefono,
                    }
                    self.toggle('edit')
                }).catch(err => console.log(err))
            },
            del($evt) {
                let self = this
                conf_rpost(`${controller}/eliminarExtension`, {
                    extension: $evt.Extension
                }, traducirFrase("Continuar esta accion eliminara la extension seleccionada")).then(result => {
                    self.load()
                }).catch(err => {
                    console.log(err)
                })
            },
            disable($evt) {
                gen_rpost(`${controller}/deshabilitarExtension`, {
                    extension: $evt.Extension
                }).then(result => { console.log(result) }).catch(err => {
                    console.log(err)
                })
            },
            toggle(target) {
                if (target == 'add') {
                    this.one = {
                        extension: '',
                        numeroPlanDeMarcacion: '',
                        voicemail: '',
                        identificadorSaliente: '',
                        usuario: '',
                        pass: '',
                        activa: false,
                        nombre: '',
                        protocolo: 'SIP',
                        tipoTelefono: '',
                    }
                }
                app.targets[target] = !app.targets[target]
            }
        },
        computed: {
            validForm() {
                return this.one.extension != ''
                    && this.one.nombre != ''
                    && this.one.numeroPlanDeMarcacion != ''
                    && this.one.usuario != ''
                    && this.one.pass != ''
            }
        },
        watch: {
            pagina() {
                this.load()
            }
        },
        updated() {
            $(".tooltipped").tooltip()
        },
        mounted() {
            $('select').formSelect()
            let self = this
            setInterval(self.load, 2000)
        },
    })

    app.load()
})()