(function () {
	const app = new Vue({
		el: "#main",
		data() {
			return {
				// Variables para la tabla
				registros: [],
				loading: true,
				headers: [
					{ label: traducirFrase("Nombre"), key: "Nombre" },
					{ label: traducirFrase("Audio Principal"), key: "AudioPrincipal" },
					{
						label: traducirFrase("Audio opción inválida"),
						key: "AudioOpcionInvalida",
					},
					{ label: traducirFrase("Audio TLE"), key: "AudioTLE" },
				],
				options: [
					{ action: "edit", tooltip: traducirFrase("Editar menú"), icon: "edit" },
					{
						action: "list",
						tooltip: traducirFrase("Administrar opciones del menú"),
						icon: "list",
					},
					{
						action: "delete",
						tooltip: traducirFrase("Eliminar menú"),
						icon: "delete",
					},
				],
				// Variables para los modales
				targets: {
					add: false,
					edit: false,
					list: false,
					listAdd: false,
					listEdit: false,
				},
				// Registrar
				one: {
					id: "",
					nombreMenu: "",
					audioPrincipal: null,
					audioTLE: null,
					audioOpcionInvalida: null,
					call_time_id: null,
				},
				// Editar
				// Paginacion
				pagina: 1,
				cuenta: 1,
				texto: "",
				// Variables para selects
				audios: [],
				audiosOpciones: [],
				opcionesDisponibles: [],
				campanas: [],
				listas: [],
				contextos: [],
				extensiones: [],
				dids: [],
				menus: [],
				gruposEntrada: [],
				calltimes: [],
				// Objeto para la administracion de opciones
				second: {
					menu: "",
					opcion: "",
					descripcion: "",
					ruta: "",
					valor: "",
					contexto: "",
					handleMethod: "CID",
					searchMethod: "LB",
					campana: "",
					lista: "",
				},
				// Variables para las opciones
				intervaloOpciones: null,
				intervaloMenus: null,
				// Variables para la tabla
				registrosOpciones: [],
				loadingOpciones: true,
				headersOpciones: [
					{ label: traducirFrase("Opción"), key: "Opcion" },
					{ label: traducirFrase("Descripción"), key: "Descripcion" },
					{
						label: traducirFrase("Ruta"),
						key: "Ruta",
					},
				],
				optionsOpciones: [
					{ action: "edit", tooltip: traducirFrase("Editar opción"), icon: "edit" },
					{
						action: "delete",
						tooltip: traducirFrase("Eliminar opción"),
						icon: "delete",
					},
				],
				// Paginacion
				paginaOpciones: 1,
				cuentaOpciones: 1,
				textoOpciones: "",
				metodosManejo: [
					{
						value: "CID",
						label: traducirFrase("Agregar un registro todo el tiempo"),
					},
					{
						value: "CIDLOOKUPRL",
						label: traducirFrase("Buscar registro en una lista"),
					},
					{
						value: "CIDLOOKUPRC",
						label: traducirFrase("Buscar registro en una campaña"),
					},
				],
				metodosBusqueda: [
					{ value: "LB", label: "LB - Load Balanced" },
					{ value: "LO", label: "Load Balanced Overflow" },
					{ value: "SO", label: "SO - Server Only" },
				],
			};
		},
		methods: {
			load() {
				let self = this;
				if (this.pagina > this.cuenta) {
					this.pagina = this.cuenta;
				}
				if (this.cuenta === 0) {
					this.pagina = 1;
				}
				gen_rpost("IVR/listarMenus", {
					pagina: this.pagina - 1,
					texto: this.texto,
				})
					.then((results) => {
						// Se sustituye el null de los audios por 'Sin audio'
						// para la tabla
						self.registros = results.Menus.map(
							({
								id,
								Nombre,
								AudioPrincipal,
								AudioTLE,
								AudioOpcionInvalida,
							}) => {
								return {
									id,
									Nombre,
									AudioPrincipal: AudioPrincipal
										? AudioPrincipal.Nombre
										: traducirFrase("Sin audio"),
									AudioTLE: AudioTLE
										? AudioTLE.Nombre
										: traducirFrase("Sin audio"),
									AudioOpcionInvalida: AudioOpcionInvalida
										? AudioOpcionInvalida.Nombre
										: traducirFrase("Sin audio"),
								};
							}
						);

						self.cuenta = Math.floor(+results.Cuenta / 15 + 1);
						if (results.Cuenta % 15 == 0) {
							self.cuenta--;
						}
						self.loading = false;
					})
					.catch((err) => {
						console.log(err);
					});
			},
			sendData(url, toggle) {
				let self = this;
				handled_rpost(`IVR/${url}`, {
					nombreMenu: this.one.nombreMenu,
					audioPrincipal: this.one.audioPrincipal,
					audioTLE: this.one.audioTLE,
					audioOpcionInvalida: this.one.audioOpcionInvalida,
					menu: this.one.id,
					call_time_id: this.one.call_time_id,
				})
					.then((res) => {
						self.toggle(toggle);
						self.load();
					})
					.catch((err) => console.log(err));
			},
			add(url, toggle) {
				this.sendData(url, toggle);
			},
			edit($evt) {
				let self = this;
				gen_rpost("IVR/obtenerMenu", {
					menu: $evt.id,
				})
					.then((res) => {
						let {
							id,
							Nombre,
							AudioPrincipal,
							AudioTLE,
							AudioOpcionInvalida,
							callTimeId
						} = res.Menu;
						self.one = {
							nombreMenu: Nombre,
							audioPrincipal: AudioPrincipal
								? AudioPrincipal.id
								: null,
							audioTLE: AudioTLE ? AudioTLE.id : null,
							audioOpcionInvalida: AudioOpcionInvalida
								? AudioOpcionInvalida.id
								: null,
							id: id,
							call_time_id: callTimeId,
						};

						self.toggle("edit");
					})
					.catch((err) => console.log(err));
			},
			del($evt) {
				let self = this;
				conf_rpost(
					"IVR/borrarMenu",
					{
						menu: $evt.id,
					},
					traducirFrase("Continuar esta acción eliminara el menú seleccionado")
				)
					.then((result) => {
						self.load();
					})
					.catch((err) => {
						console.log(err);
					});
			},
			list($evt) {
				clearInterval(this.intervaloMenus);
				this.second.menu = $evt.id;
				this.intervaloOpciones = setInterval(
					() => this.cargaOpciones(),
					3000
				);
				this.toggle("list");
			},
			// Metodos para las opciones
			cargaOpciones() {
				let self = this;
				if (this.paginaOpciones > this.cuentaOpciones) {
					this.paginaOpciones = this.cuentaOpciones;
				}
				gen_rpost("IVR/listarOpciones", {
					menu: this.second.menu,
					pagina: this.paginaOpciones - 1,
					texto: this.textoOpciones,
				})
					.then((results) => {
						// Se sustituye el null de los audios por 'Sin audio'
						// para la tabla
						self.registrosOpciones = results.Opciones.map(
							({ Opcion, Descripcion, Ruta }) => {
								let ruta = Ruta;

								switch (ruta) {
									case "PHONE":
										ruta = traducirFrase("Telefono");
										break;
									case "EXTENSION":
										ruta = traducirFrase("Extensión");
										break;
									case "HANGUP":
										ruta = traducirFrase("Colgar");
										break;
									case "DID":
										ruta = traducirFrase("Telefono DID");
										break;
									case "INGROUP":
										ruta = traducirFrase("Grupo de entrada");
										break;
									case "CALLMENU":
										ruta = traducirFrase("Menú");
										break;
									case "VOICEMAIL":
										ruta = traducirFrase("Buzón de voz");
										break;
								}

								return {
									Opcion,
									Descripcion,
									Ruta: ruta,
								};
							}
						);

						self.cuentaOpciones = Math.floor(
							+results.Cuenta / 15 + 1
						);
						if (results.Cuenta % 15 == 0) {
							self.cuentaOpciones--;
						}
						self.loadingOpciones = false;
					})
					.catch((err) => {
						console.log(err);
					});
			},
			detenerOpciones() {
				clearInterval(this.intervaloOpciones);
				this.intervaloMenus = setInterval(this.load, 2000);
			},
			enviarOpcion(url, toggle) {
				const {
					menu,
					opcion,
					descripcion,
					valor,
					contexto,
					ruta,
				} = this.second;
				let self = this;
				handled_rpost(`IVR/${url}`, {
					menu,
					opcion,
					descripcion,
					valor,
					contexto,
					ruta,
				})
					.then((res) => {
						self.toggle(toggle);
						self.cargaOpciones();
					})
					.catch((err) => console.log(err));
			},
			addOpcion(url, toggle) {
				if (
					this.second.ruta !== "EXTENSION" ||
					this.second.ruta !== "INGROUP"
				) {
					this.second.contexto = "";
				}
				if (this.second.ruta === "INGROUP") {
					const {
						handleMethod,
						searchMethod,
						campana,
						lista,
					} = this.second;
					this.second.contexto = `${handleMethod},${searchMethod},${lista},${campana},1,,,,`;
				}
				this.enviarOpcion(url, toggle);
			},
			editOpcion($evt) {
				let self = this;
				gen_rpost("IVR/obtenerOpcion", {
					opcion: $evt.Opcion,
					menu: this.second.menu,
				})
					.then((res) => {
						let {
							Opcion,
							Descripcion,
							Ruta,
							Contexto,
							Valor,
						} = res.Opcion;
						const { menu } = self.second;
						let handleMethod = "CID";
						let searchMethod = "LB";
						let campana = "";
						let lista = "";

						// Codigo para los handleMethod,
						// searchMethod, campana y lista
						if (Ruta === "INGROUP") {
							[
								handleMethod,
								searchMethod,
								lista,
								campana,
							] = Contexto.split(",");
						}

						self.second = {
							menu,
							handleMethod,
							searchMethod,
							campana,
							lista,
							opcion: Opcion,
							descripcion: Descripcion,
							ruta: Ruta,
							contexto: Contexto,
							valor: Valor,
						};

						self.toggle("listEdit");
					})
					.catch((err) => console.log(err));
			},
			delOpcion($evt) {
				let self = this;
				conf_rpost(
					"IVR/borrarOpcion",
					{
						menu: this.second.menu,
						opcion: $evt.opcion,
					},
					traducirFrase("Continuar esta acción eliminara la opción seleccionada")
				)
					.then((result) => {
						self.cargaOpciones();
					})
					.catch((err) => {
						console.log(err);
					});
			},
			// Metodos para las opciones
			obtenerAudios() {
				const self = this;
				gen_rpost("IVR/seleccionarAudios", {})
					.then((r) => {
						self.audios = r.Archivos.map((audio) => ({
							value: audio.id,
							label: audio.Nombre,
						}));
					})
					.catch(console.log);
			},
			obtenerAudiosOpcion() {
				const self = this;
				gen_rpost("IVR/seleccionarAudios", {})
					.then((r) => {
						self.audiosOpciones = r.Archivos.map((audio) => ({
							value: audio.Hash,
							label: audio.Nombre,
						}));
					})
					.catch(console.log);
			},
			obtenerCampanas() {
				const self = this;
				gen_rpost("Campanas/getCampaignsSelect", {})
					.then((r) => {
						self.campanas = r.Campanas.map((campana) => ({
							value: campana.campaign_id,
							label: campana.campaign_name,
						}));
					})
					.catch(console.log);
			},
			obtenerListas() {
				const self = this;
				gen_rpost("Listas/getListsSelect", {})
					.then((r) => {
						self.listas = r.Listas.map((r) => ({
							value: r.list_id,
							label: r.list_name,
						}));
					})
					.catch(console.log);
			},
			obtenerOpcionesDisponibles() {
				const self = this;
				gen_rpost("IVR/seleccionarOpciones", {
					menu: this.second.menu,
				})
					.then((r) => {
						self.opcionesDisponibles = Object.values(r.Opciones).map((opcion) => ({
							value: opcion,
							label: opcion,
						}));
						if (self.second.opcion !== "") {
							self.opcionesDisponibles.push({
								value: self.second.opcion,
								label: self.second.opcion,
							})
						}
						self.opcionesDisponibles.push({})
					})
					.catch(console.log);
			},
			obtenerContextos() {
				const self = this;
				gen_rpost("Contextos/getSelect", {})
					.then((r) => {
						self.contextos = r.Registros.map((contexto) => ({
							value: contexto.id,
							label: contexto.nombre,
						}));
					})
					.catch(console.log);
			},
			obtenerExtensiones() {
				const self = this;
				gen_rpost("Telefono/seleccionarExtensiones", {})
					.then((r) => {
						self.extensiones = r.Extensiones.map((extension) => ({
							value: extension.Extension,
							label: extension.Nombre,
						}));
					})
					.catch(console.log);
			},
			obtenerDIDs() {
				const self = this;
				gen_rpost("IVR/seleccionarTelefonosDID", {})
					.then((r) => {
						self.dids = r.TelefonosDID.map((did) => ({
							value: did.DIDExtension,
							label: did.Descripcion,
						}));
					})
					.catch(console.log);
			},
			obtenerMenus() {
				const self = this;
				gen_rpost("IVR/seleccionarMenus", {})
					.then((r) => {
						self.menus = r.Menus.map((menu) => ({
							value: menu.id,
							label: menu.Nombre,
						}));
					})
					.catch(console.log);
			},
			obtenerGruposEntrada() {
				const self = this;
				gen_rpost("GrupoDeEntrada/seleccionarIngroups", {})
					.then((r) => {
						self.gruposEntrada = r.Ingroups.map((ingroup) => ({
							value: ingroup.id,
							label: ingroup.Nombre,
						}));
					})
					.catch(console.log);
			},
			toggle(target) {
				if (target == "add") {
					this.one = {
						nombreMenu: "",
						audioPrincipal: null,
						audioTLE: null,
						audioOpcionInvalida: null,
						id: "",
						call_time_id: null,
					};
				}
				if (target === "add" || target === "edit") {
					this.obtenerAudios();
				}
				if (target === "listAdd") {
					const { menu } = this.second;
					this.second = {
						menu,
						opcion: "",
						valor: "",
						contexto: "",
						descripcion: "",
						ruta: "HANGUP",
						handleMethod: "CID",
						searchMethod: "LB",
						campana: "",
						lista: "",
					};
				}
				if (target === "listAdd" || target === "listEdit") {
					this.obtenerAudiosOpcion();
					this.obtenerListas();
					this.obtenerCampanas();
					this.obtenerOpcionesDisponibles();
					this.obtenerContextos();
					this.obtenerExtensiones();
					this.obtenerDIDs();
					this.obtenerMenus();
					this.obtenerGruposEntrada();
				}
				selectCallTimes().then(r => {
					this.calltimes = r;
				})
				app.targets[target] = !app.targets[target];
			},
		},
		computed: {
			validForm() {
				return this.one.nombreMenu !== "";
			},
			validFormOpciones() {
				return this.second.opcion !== "";
			},
		},
		watch: {
			pagina() {
				this.load();
			},
		},
		updated() {
			$(".tooltipped").tooltip();
		},
		mounted() {
			// Revisar => $('select').formSelect();
			let self = this;
			this.intervaloMenus = setInterval(self.load, 2000);
		},
	});

	app.load();
})();
