<script>
    Vue.component('table-dialvox', {
        data(){
            return {}
        },
        props: {
            id: { type: String, default: "id" }, // Clave para acceder al id del objeto
            headers: { type: Array, default: [] }, // Headers: [{ id: String?, label: String }]
            data: { type: Array, default: [] }, // Data: [{ key: Value <- Coinciden con el numero de headers, id? : String }]
            options: { type: Array, default: [] }, // Options: [{ action: String, tooltip: String, icon: String }]
            // De options
            // El action sirve como identificador y como el nombre del evento emitido, por ejemplo
            // para action: "delete", el componente de tabla emite el evento v-on:delete
            // <table-dialvox options="[..., {..., action: 'delete'}]" @delete="handler($event)"></table-dialvox>
            // ademas el objeto del evento emitido es el objeto del registro que se hizo click
            // tooltip es el titulo del tootlip que se mostrara, no es obligatorio
            disabled: { type: String, default: null }, // Switch: cadena que indica si se va a mostrar un switch para activar/desactivar
            disabledText: { type: String, default: '' },
            supervisor: {type: Boolean},
            // Si se agrega, debe ser el atributo exacto del objeto del registro que representa si esta activo o no
            // Al cambiar el switch se emite el evento switched
            // Los valores aceptados para activo es 'Y' o 'N'
            loading: { type: Boolean, default: false }, // Muestra el spinner de carga
            hsearch: { type: Boolean, default: false } // Oculta el buscador
        },
        template: `<?php include "table.component.html.php"?>`,
    })
</script>