<modal-dialvox v-model="modalCategoriasCRM" small :disabled="true" cancel="Cerrar">
    <h4>{{traducirFrase("Categorias de campo")}}</h4>
    <br><br>
    <div class="container">
        <div class="row">
            <div class="container col s12" v-if="editandoCategoria">
                <div class="row">
                    <div class="input-field col s6">
                        <input type="text" v-model="categoriaEnEdicion.Nombre">
                        <label class="active">{{traducirFrase("Nombre")}}</label>
                    </div>
                    <div class="input-field col s6">
                        <input type="number" v-model="categoriaEnEdicion.Posicion" min="0">
                        <label class="active">{{traducirFrase("Posicion")}}</label>
                    </div>
                    <div class="input-field col s12">
                        <p>
                            <label>
                                <input type="checkbox" v-model="categoriaEnEdicion.Contraido">
                                <span>{{traducirFrase("Contraido")}}</span>
                            </label>
                        </p>
                    </div>
                    <div class="input-field col s12 right-align">
                        <button class="btn blue darken-1 waves-effect waves-light" @click="guardarCategoria">
                            {{traducirFrase("Guardar")}}
                        </button>
                        <button class="btn red waves-effect waves-light" @click="cancelarEdicionCategoria">
                            {{traducirFrase("Cancelar")}}
                        </button>
                    </div>
                </div>
            </div>
            <div class="container col s12" v-else>
                <button class="btn blue darken-1" @click="agregarCategoria" type="button">
                    {{traducirFrase("Agregar categoria")}}
                </button>
            </div>
            <table-dialvox
                :headers="[
                    { label: traducirFrase('Nombre'), key: 'Nombre'},
                    { label: traducirFrase('Posicion'), key: 'Posicion'}
                ]"
                :data="categorias"
                :options='[
                    {
						action: "delete",
						tooltip: traducirFrase("Eliminar categoria"),
						icon: "delete",
                    },
                    {
						action: "edit",
						tooltip: traducirFrase("Edita categoria"),
						icon: "edit",
                    }
                ]'
                :loading="false"
                @delete="eliminarCategoria($event)"
                @edit="editarCategoria($event)"
            ></table-dialvox>
        </div>
    </div>
</modal-dialvox>
