<modal-dialvox v-model="tono" :cancel="traducirFrase('Cancelar')" @closed="closeTono()" :disabled="true">
    <h4>{{traducirFrase("Tono de llamada")}}</h4>
    <br>
    <form method="post" v-on:submit.prevent="eliminarTono" ref="form_tono">
        <div class="container" style="display:flex;flex-direction:column;">
            <input type="hidden" :value="id_cliente" name="idCliente" />
            <div style="display: flex; flex-direction:row; gap: 1rem;align-items: center;" v-if="tono">
                <div class="file-field input-field">
                    <button class="btn-small z-depth-0 red lighten-4 waves-effect waves-light red-text" type="submit">
                        <i class="material-icons left">delete</i>Eliminar
                    </button>
                </div>
                <audio controls style="flex: 1;">
                    <source :src="tono_url">
                </audio>
            </div>
        </div>
    </form>
    <form method="post" enctype="multipart/form-data" v-on:submit.prevent="subirTono" ref="form_tono">
        <div class="container" style="display:flex;flex-direction:column;">
            <input type="hidden" :value="id_cliente" name="idCliente" />
            <div style="display: flex; flex-direction:row; gap: 1rem;">
                <div class="file-field input-field" style="flex: 1">
                    <div class="btn-small z-depth-0 teal lighten-4 waves-effect waves-light teal-text">
                        <span>{{traducirFrase("Seleccionar audio")}}</span>
                        <input type="file" name="audio">
                    </div>
                    <div class="file-path-wrapper">
                        <input class="file-path" type="text">
                    </div>
                </div>
            </div>
            <div style="display: flex; flex-direction:column; gap: 0.2rem; padding: 0.8rem 0.2rem;">
                <div style="display: flex; flex-direction: row; gap: 1rem; justify-content:flex-end; margin: 0.2rem 0;">
                    <button class="btn-small z-depth-0 grey lighten-4 waves-effect waves-light blue-grey-text" type="submit">
                        Actualizar tono
                    </button>
                </div>
            </div>
        </div>
    </form>
</modal-dialvox>