let vue_obj;
(function () {
	const headersLeads = [
		{ label: '#', key: '#' },
		{ label: 'ID', key: 'lead_id' },
		{ label: traducirFrase('Telefono'), key: 'phone' },
		{ label: traducirFrase('Estado'), key: 'status' },
		{ label: traducirFrase('Ultimo usuario'), key: 'last_agent' },
		{ label: traducirFrase('ID Lista'), key: 'list_id' },
	];

	const headersLogs = [
		{ label: '#', key: '#' },
		{ label: traducirFrase('Tipo'), key: 'type' },
		{ label: traducirFrase('Telefono'), key: 'phone' },
		{ label: traducirFrase('Fecha de llamada'), key: 'call_date' },
		{ label: traducirFrase('Usuario'), key: 'user' },
		{ label: traducirFrase('Duracion'), key: 'length' },
		{ label: traducirFrase('Estado'), key: 'status' },
		{ label: traducirFrase('ID Campaña'), key: 'campaign' },
		{ label: traducirFrase('ID Lista'), key: 'list_id' },
	];

	const optionsLeads = [
		{
			action: 'details',
			tooltip: traducirFrase('Ver detalles del lead'),
			icon: 'info_outline',
		},
	];

	const leadDetailsDefault = {
		agent: [],
		calls: [],
		closer: [],
		ivr: [],
		leadInfo: {
			phone_number: '',
			alt_phone: '',
			first_name: '',
			last_name: ''
		},
		park: [],
		record: [],
	};

	const app = new Vue({
		el: '#main',
		data() {
			return {
				cargando: false,
				buscarPor: 'vendor_lead_code',
				valor: '',
				telefonoAlterno: false,
				data: [],
				leadDetails: leadDetailsDefault,
				modalLeadDetails: false,
				headersLeadDetails: {
					calls: [
						{ label: traducirFrase('Fecha'), key: 'call_date' },
						{ label: traducirFrase('Duracion'), key: 'length_in_sec' },
						{ label: traducirFrase('Telefono'), key: 'phone_number' },
						{ label: traducirFrase('Usuario'), key: 'user' },
					],
					agent: [
						{ label: traducirFrase('Fecha'), key: 'event_time' },
						{ label: traducirFrase('Usuario'), key: 'user' },
						{ label: traducirFrase('ID de Campaña'), key: 'campaign_id' },
						{ label: traducirFrase('Tiempo (En pausa)'), key: 'pause_sec' },
						{ label: traducirFrase('Tiempo (En espera)'), key: 'wait_sec' },
						{ label: traducirFrase('Tiempo (En llamada)'), key: 'talk_sec' },
						{ label: traducirFrase('Tiempo (Calificando)'), key: 'dispo_sec' },
					],
					closer: [
						{ label: traducirFrase('Fecha'), key: 'call_date' },
						{ label: traducirFrase('Duracion'), key: 'length_in_sec' },
						{ label: traducirFrase('Usuario'), key: 'user' },
						{ label: traducirFrase('Estado'), key: 'status' },
						{ label: traducirFrase('Tiempo (En espera)'), key: 'queue_seconds' },
					],
					park: [
						{ label: traducirFrase('Fecha'), key: 'parked_time' },
						{ label: traducirFrase('Estado'), key: 'status' },
						{ label: traducirFrase('Usuario'), key: 'user' },
						{ label: traducirFrase('Fecha (Al tomarse)'), key: 'grab_time' },
						{ label: traducirFrase('Fecha (Al colgar)'), key: 'hangup_time' },
						{ label: traducirFrase('Tiempo (En espera)'), key: 'parken_sec' },
						{ label: traducirFrase('Tiempo (En llamada)'), key: 'talked_sec' },
					],
					ivr: [
						{ label: traducirFrase('ID de Campaña'), key: 'campaign_id' },
						{ label: traducirFrase('Fecha'), key: 'event_date' },
						{ label: traducirFrase('ID de Menu'), key: 'menu_id' },
						{ label: traducirFrase('Accion'), key: 'menu_action' },
					],
					records: [],
				},
				headersDid: [
					{ label: '#', key: '#' },
					{ label: 'DID', key: 'did' },
					{ label: traducirFrase('Telefono'), key: 'phone' },
					{ label: traducirFrase('Fecha de llamada'), key: 'call_date' },
				],
				dataDids: [],
				usuarios: [],
				listas: [],
				gruposSelect: [
					{
						grupo: 'Leads',
						opciones: [
							{
								value: 'vendor_lead_code',
								label: traducirFrase('Vendor Lead Code'),
							},
							{
								value: 'phone_number',
								label: traducirFrase('Telefono (o Tel. Alt)'),
							},
							{
								value: 'lead_id',
								label: 'ID',
							},
							{
								value: 'detailed',
								label: traducirFrase('Busqueda detallada'),
							},
						],
					},
					{
						grupo: traducirFrase('Registros'),
						opciones: [
							{
								value: 'log_lead_id',
								label: traducirFrase('Lead ID'),
							},
							{
								value: 'log_phone',
								label: traducirFrase('Telefono'),
							},
							{
								value: 'log_lead_id_archive',
								label: traducirFrase('Lead ID (Archivado)'),
							},
							{
								value: 'log_phone_archive',
								label: traducirFrase('Telefono (Archivado)'),
							},
						],
					},
				],
			};
		},
		computed: {
			headers() {
				if (
					[
						'log_lead_id',
						'log_phone',
						'log_lead_id_archive',
						'log_phone_archive',
					].includes(this.buscarPor)
				) {
					return headersLogs;
				}
				return headersLeads;
			},
			options() {
				if (
					[
						'log_lead_id',
						'log_phone',
						'log_lead_id_archive',
						'log_phone_archive',
					].includes(this.buscarPor)
				) {
					return undefined;
				}
				return optionsLeads;
			},
		},
		watch: {
			buscarPor(newVal, oldVal) {
				if (newVal !== 'phone_number') {
					this.telefonoAlterno = false;
				}
				if (newVal === 'detailed') {
					this.valor = {
						status: '',
						user: '',
						list_id: '',
					};
				} else {
					this.valor = '';
				}
				this.data = [];
				this.dataDids = [];
			},
		},
		methods: {
			load() {
				const params = {};
				if (this.buscarPor === 'detailed') {
					Object.keys(this.valor).forEach((key) => {
						if (this.valor[key] !== '') {
							params[key] = this.valor[key];
						}
					});
				} else {
					params[this.buscarPor] = this.valor;
				}
				if (this.buscarPor === 'phone_number') {
					params['alt_phone_search'] = this.telefonoAlterno ? 1 : 0;
				}
				gen_rpost('Listas/searchLead', params)
					.then((r) => {
						this.cargarUsuarios();
						this.cargarListas();
						if (r.leads) {
							this.data = r.leads;
							this.dataDids = [];
						} else {
							const data = [];

							r.logs.outbound.forEach((v) => {
								const val = Object.assign({}, v);
								val['type'] = 'Salida';
								data.push(val);
							});

							r.logs.inbound.forEach((v) => {
								const val = Object.assign({}, v);
								val['type'] = 'Entrada';
								data.push(val);
							});

							this.data = data;

							if (r.logs.did) {
								this.dataDids = r.logs.did;
							}
						}
					})
					.catch(console.log);
			},
			cargarUsuarios() {
				gen_rpost('Usuarios/getUserSelect', {}).then((r) => {
					this.usuarios = r.usuarios.map((usuario) => ({
						value: usuario.user,
						label: usuario.full_name,
					}));
				});
			},
			cargarListas() {
				gen_rpost('Listas/getListsSelect', {}).then((r) => {
					this.listas = r.Listas.map((lista) => ({
						value: lista.list_id,
						label: lista.list_name,
					}));
				});
			},
			mostrarDetalles(item) {
				handled_rpost('Listas/showLead', {
					lead_id: item.lead_id,
				})
					.then((r) => {
						this.leadDetails = {
							leadId: item.lead_id,
							leadInfo: r.lead_info,
							agent: r.agent,
							calls: r.calls,
							closer: r.closer,
							ivr: r.ivr,
							park: r.park,
							record: r.record,
						}
						this.modalLeadDetails = true
					})
					.catch(console.log);
			},
			cerrarDetalles() {
				this.leadDetails = leadDetailsDefault
				this.modalLeadDetails = false
			}
		},
		updated() {
			$('.tooltipped').tooltip();
		},
		mounted() {
			// let self = this;
			// setInterval(self.load, 20000);
			this.cargarUsuarios();
			this.cargarListas();
		},
	});

	vue_obj = app;
})();
