var statusPausa = false;
let mamadasPendejas = false;
// =================================================================
// Id del timeout que se ejecutara si el estado de pausa
// tenia un tiempo limite
let idTimeoutTiempoLimite = null;
// =================================================================
// Id del registro de pausa cuando se expira el tiempo
let idReportePausa = '';
// =================================================================
function ocultapausa() {
	$('#codPausa').hide();
	statusCalificacion = false;
	$('#botonPausaCalificar').attr('disabled', true);
}

function pideRazonPausa(id) {
	if (statusPausa) {
		statusPausa = false;
		$.ajax({
			url: MODULOS + 'EstadosPausa/getStatusesSelect',
			type: 'POST',
			dataType: 'text',
			success: function (result) {
				var resp = JSON.parse(result);
				console.log(resp);
				if (resp.Estado == 'ok') {
					$('#codigosPausa').html('');
					if (resp.Registros.length > 0) {
						for (var i = 0; i < resp.Registros.length; i++) {
							if (id == resp.Registros[i].estado) {
								$('#codigosPausa').append(`
									<a 
										href="#" 
										style="padding: 5 px;" 
										class="letraSize col-sm-3  bg-success text-white text-center list-group-item list-group-item-secondary text-wrap" 
										onclick="enviaPausa(
											'${resp.Registros[i].estado}',1,${resp.Registros[i].tiempo_limite},'${resp.Registros[i].requiere_aprovacion}','${resp.Registros[i].cantidad}'
										)"
									>
										${resp.Registros[i].estado}-${resp.Registros[i].nombre}
									</a>`);
							} else {
								$('#codigosPausa').append(`
									<a 
										href="#" 
										style="padding: 5 px;" 
										class="letraSize col-sm-3  botonCalificar text-center list-group-item-action text-wrap" 
										onclick="enviaPausa('${resp.Registros[i].estado}',0,${resp.Registros[i].tiempo_limite},'${resp.Registros[i].requiere_aprovacion}','${resp.Registros[i].cantidad}')"
									>
										${resp.Registros[i].estado}-${resp.Registros[i].nombre}
									</a>
								`);
							}
						}
						if (!id) {
							document
								.getElementById('my_iframe')
								.contentWindow.PauseCodeSelectContent_create(
									'YES'
								);
						}
					} else {
						enviaPausa('PAUSA', 1, -1, '0');
					}
				} else {
					$('#ListaAlert').html(i18n.gettext(resp.Descripcion));
					crearTooltip();
				}
			},
			error: function (error) {
				console.log(error);
			},
		});
	}
}

function pausaAgente() {
	bloquearPlay = false;
	document
		.getElementById('my_iframe')
		.contentWindow.AutoDial_ReSume_PauSe(
			'VDADpause',
			'',
			'',
			'',
			'',
			'',
			'',
			'YES'
		);
	$('#codPausa').show();
	statusPausa = true;
	$('#botonPausaCalificar').attr('disabled', false);
	pideRazonPausa();
}
function truncaPausa() {
	Enpausa = false;
}
function enviaPausa(id, cant, tiempo_limite, requiere_aprovacion, cantidad, noCerrarModal) {
	/*
		El tiempo_limite determina en segundos cuando un agente a rebasado
		el tiempo limite en que puede estar en pausa. Si el tiempo_limite es
		< 0 la pausa no tendra tiempo limite.
		Si se requiere_aprovacion un supervisor y solo un supervisor
		puede desactivar la pausa, donde se generara un reporte de pausa.
	*/
	console.log(cantidad);
	if (cant == 0) {
		statusPausa = true;
		pideRazonPausa(id);
	} else {
		Enpausa = true;
		let tiempo_quepaso = 0;
		let pausa_contador = setInterval(HandleContador, 1000);
		function HandleContador() {
			let horas = Math.floor(tiempo_limite / 3600);
			let minutos = Math.floor((tiempo_limite % 3600) / 60);
			let segundos = tiempo_limite % 60;
			horas = String(horas).padStart(2, '0');
			minutos = String(minutos).padStart(2, '0');
			segundos = String(segundos).padStart(2, '0');

			$('#pause_time_left').text(
				'TIEMPO RESTANTE DE PAUSA: ' +
					horas +
					':' +
					minutos +
					':' +
					segundos
			);

			if (tiempo_limite > 0 || cantidad <= 0) {
				tiempo_limite--;
				tiempo_quepaso++;
			} else {
				Enpausa = false;
			}

			if (!Enpausa) {
				$('#pause_time_left').text('');
				$.ajax({
					url: 'EstadosPausa/resumePause',
					type: 'POST',
					data: {
						usuario: Usuario,
						campana: campanaActual,
						codigoPausa: id,
						tiempo: tiempo_quepaso,
					},
					dataType: 'text',
					success: function (response) {
						var res = JSON.parse(response);
						if (res.Estado == 'ok') {
							console.log('todo bien :)');
						} else {
							console.log('algo salio mal');
							console.log(res.Descripcion);
						}
					},
					error: function (res) {
						console.log(res);
					},
				});
				clearInterval(pausa_contador);
				tiempo_quepaso = 0;
			}
		}
		document
			.getElementById('my_iframe')
			.contentWindow.PauseCodeSelect_submit(id, 'YES');

		console.log('nocerrarmodal', noCerrarModal)
		if (!noCerrarModal) {
			ocultapausa();
		}

		if (cantidad <= 0) {
			console.log('Tiempo limite de pausa superado');
			Enpausa = false;
			crearRegistroReportePausa(id).then((_) => {
				if (requiere_aprovacion === '1') {
					$('#modalTiempoLimitePausa').modal('show');
					localStorage.setItem('idReportePausa', idReportePausa);
				}
				idTimeoutTiempoLimite = null;
			});
		}
		if (tiempo_limite > 0) {
			idTimeoutTiempoLimite = setTimeout(() => {
				console.log('Tiempo limite de pausa superado');
				Enpausa = false;
				crearRegistroReportePausa(id).then((_) => {
					if (requiere_aprovacion === '1') {
						$('#modalTiempoLimitePausa').modal('show');
						localStorage.setItem('idReportePausa', idReportePausa);
					}
					idTimeoutTiempoLimite = null;
				});
			}, tiempo_limite * 1000);
		} else {
			idTimeoutTiempoLimite = null;
			Enpausa = false;
		}
	}
}

function nextDialMan() {
	clearTimeout(idTimeoutTiempoLimite);
	bloquearRedial = true;
	if (bln_dial_block) {
		return;
	}
	bln_dial_block = true;
	if (!enLlamada) {
		if (!bloquearPlay || mamadasPendejas != 2) {
			mamadasPendejas = 2;
			bloquearPlay = true;
			document
				.getElementById('my_iframe')
				.contentWindow.AutoDial_ReSume_PauSe(
					'VDADpause',
					'',
					'',
					'',
					'',
					'',
					'',
					'YES'
				);
			document
				.getElementById('my_iframe')
				.contentWindow.PauseCodeSelectContent_create('YES');
			document
				.getElementById('my_iframe')
				.contentWindow.PauseCodeSelect_submit('NEXT', 'YES');
			setTimeout(() => {
				if (!enLlamada) {
					document
						.getElementById('my_iframe')
						.contentWindow.ManualDialNext(
							'',
							'',
							'',
							'',
							'',
							'0',
							'',
							'',
							'YES'
						);
				}
			}, 2000);
			otraFlag = true;
		} else {
			alert(
				'Acabas de presionar el boton de play, espera por la llamada'
			);
		}
	}
}

function playAgente() {
	clearTimeout(idTimeoutTiempoLimite);
	bandera_pausa = false;
	if (!enLlamada) {
		if (!bloquearPlay || mamadasPendejas != 1) {
			Enpausa = false;
			bloquearPlay = true;
			mamadasPendejas = 1;
			if (Manual === 'MANUAL') {
				nextDialMan();
			} else {
				if (_FORZAR_PAUSA && !_FORZAR_PAUSA_SONANDO) {
					enviaPausa(_FORZAR_PAUSA_CODIGO, 1, -1, '0');
				} else {
					document
						.getElementById('my_iframe')
						.contentWindow.AutoDial_ReSume_PauSe(
							'VDADready',
							'',
							'',
							'',
							'',
							'',
							'',
							'YES'
						);
				}
				// Eliminar el timeout por que ya se quito la pausa
			}
		} else {
			alert(
				'Acabas de presionar el boton de play, espera por la llamada'
			);
		}
	}
}

function detenerAgente() {
	$('#btnPlay').addClass('disabled');
	$('#btnPause').addClass('disabled');
	$('#btnPause').addClass('d-none');
	$('#btnRecord').html('<i class="fas fa-dot-circle controles"></i>');
}

// Funcion para hacer peticiones
function $_post(url, data) {
	return $.post(MODULOS + url, data)
		.then((r) => {
			if (r.Estado === 'ok') {
				return r;
			} else {
				throw r;
			}
		})
		.catch((e) => {
			throw e;
		})
		.catch((e) => {
			console.error(e);
			if (!e.Descripcion) {
				throw {
					Descripcion: 'Error desconocido',
				};
			}
			throw e;
		});
}

// Funciona para hacer el registro de reporte del estado de pausa
function crearRegistroReportePausa(pauseCode) {
	return $_post('HomeAgente/createPauseReport', { pauseCode })
		.then((r) => {
			idReportePausa = r.idReport;
		})
		.catch((e) => {});
}

// Funcion para cuando se cierra el modal si se requiere aprovacion del
// del supervisor
function reanudarAgenteTimepoLimiteExcedido() {
	const data = {
		usuario: $('#usuarioSupervisorPausa').val(),
		password: $('#passwordSupervisorPausa').val(),
		idReport: idReportePausa,
	};
	return $_post('HomeAgente/checkSupervisor', data)
		.then(() => {
			$('#passwordSupervisorPausa').val('');
			$('#usuarioSupervisorPausa').val('');
		})
		.catch((e) => {
			$('#passwordSupervisorPausa').val('');
			$('#usuarioSupervisorPausa').val('');
			throw e;
		});
}

$('#iniciarSupervisor').click((e) => {
	const m_error = $('#mensajeErrorTiempoLimitePausa');
	reanudarAgenteTimepoLimiteExcedido()
		.then((_) => {
			$('#modalTiempoLimitePausa').modal('hide');
			m_error.text('');
			m_error.hide();
			localStorage.removeItem('idReportePausa');
		})
		.catch((e) => {
			m_error.text(e.Descripcion);
			m_error.show();
		});
});

// Mostrar modal si reinicio pantalla
if (localStorage.getItem('idReportePausa')) {
	idReportePausa = localStorage.getItem('idReportePausa');
	$('#modalTiempoLimitePausa').modal('show');
}
