<?php
require_once 'Lista.php';
require_once 'CRM/CRMDatos.php';
require_once RUTA_APP . 'Conexion.php';
class ListaDatos
{

    public static function getListasByCampana(string $id): ?array
    {
        $retorno = array();
        $con = getConnection();
        $query = "SELECT list_id,list_name,campaign_id,active,list_description,list_changedate FROM vicidial_lists WHERE campaign_id = '" . limpia($id) . "'";
        if ($result = sv_mysqli_query($con, $query)) {
            while ($row = sv_mysqli_fetch_array($result)) {
                $crm = null;
                $queryCRM = "SELECT CRM FROM dialvox_crm_lista WHERE Lista = '" . $row["list_id"] . "' LIMIT 1";
                if ($resultCRM = sv_mysqli_query($con, $queryCRM)) {
                    if ($rowCRM = sv_mysqli_fetch_array($resultCRM)) {
                        $crm = CRMDatos::getCRMById($rowCRM["CRM"]);
                    }
                }
                $retorno[] = new Lista($row["list_id"], $row["list_name"], CampanaDatos::getCampanaById($row["campaign_id"]), $crm, $row["active"], $row["list_description"], $row["list_changedate"]);
            }
        }
        sv_mysqli_close($con);
        return $retorno;
    }

    public static function getListaById(string $id): ?Lista
    {
        $retorno = null;
        $con = getConnection();
        $query = "SELECT list_id,list_name,campaign_id,active,list_description,list_changedate FROM vicidial_lists WHERE list_id = '" . limpia($id) . "' LIMIT 1";
        if ($result = sv_mysqli_query($con, $query)) {
            if ($row = sv_mysqli_fetch_array($result)) {
                $crm = null;
                $queryCRM = "SELECT CRM FROM dialvox_crm_lista WHERE Lista = '" . $row["list_id"] . "' LIMIT 1";
                if ($resultCRM = sv_mysqli_query($con, $queryCRM)) {
                    if ($rowCRM = sv_mysqli_fetch_array($resultCRM)) {
                        $crm = CRMDatos::getCRMById($rowCRM["CRM"]);
                    }
                }
                $retorno = new Lista($row["list_id"], $row["list_name"], CampanaDatos::getCampanaById($row["campaign_id"]), $crm, $row["active"], $row["list_description"], $row["list_changedate"]);
            }
        }
        sv_mysqli_close($con);
        return $retorno;
    }
    public static function getListaByLeadId(string $leadId): ?Lista
    {
        $retorno = null;
        $con = getConnection();
        $query = "SELECT list_id FROM vicidial_list WHERE lead_id = '" . limpia($leadId) . "' LIMIT 1";
        if ($result = sv_mysqli_query($con, $query)) {
            if ($row = sv_mysqli_fetch_array($result)) {
                $retorno = self::getListaById($row["list_id"]);
            }
        }
        sv_mysqli_close($con);
        return $retorno;
    }
    public static function getLeadsByListId(string $listaId): array
    {
        $retorno = array();
        $con = getConnection();
        $query = "SELECT lead_id FROM vicidial_list WHERE list_id = '" . limpia($listaId) . "'";
        if ($result = sv_mysqli_query($con, $query)) {
            while ($row = sv_mysqli_fetch_array($result)) {
                $retorno[] = $row["lead_id"];
            }
        }
        sv_mysqli_close($con);
        return $retorno;
    }
    public static function getCurrentListByUsuario(Usuario $usuario): ?Lista
    {
        $retorno = null;
        $con = getConnection();
        $query = "SELECT list_id FROM vicidial_list WHERE lead_id = (SELECT lead_id FROM vicidial_live_agents WHERE user = '" . limpia($usuario->getUsuario()) . "' LIMIT 1)";
        if ($result = sv_mysqli_query($con, $query)) {
            if ($row = sv_mysqli_fetch_array($result)) {
                $retorno = self::getListaById($row["list_id"]);
            }
        }
        sv_mysqli_close($con);
        return $retorno;
    }
    public static function insertLista(Lista $lista): ?int
    {
        $retorno = 0;
        $con = getConnection();
        $query = "INSERT INTO vicidial_lists (list_id,list_name,campaign_id,active,list_description,list_changedate) VALUES ('" . limpia($lista->getId()) . "','" . limpia($lista->getNombre()) . "','" . limpia($lista->getCampana()->getId()) . "','" . limpia($lista->isActiva()) . "','" . limpia($lista->getDescripcion()) . "','" . limpia($lista->getFechaUltimaMarcacion()) . "')";
        if ($result = sv_mysqli_query($con, $query)) {
            $retorno = 1;
        } else {
            $retorno = abs(mysqli_errno($con)) * -1;
        }
        sv_mysqli_close($con);
        return $retorno;
    }
    public static function updateLista(Lista $lista): ?int
    {

    }
    public static function deleteLista(Lista $lista): ?int
    {

    }
}
