(function () {
	const app = new Vue({
		el: "#main",
		data() {
			return {
				registros: [],
			};
		},
		methods: {
			generateReport() {
				const self = this;
				const fechas = $("#fechaReportePausa").val();
				let [fechaIni, fechaFin] = fechas.split(" - ");
				if (!fechaFin) {
					fechaFin = fechaIni;
				}
				rget("EstadosPausa/generateReport", {
					fechaIni,
					fechaFin,
				})
					.then((r) => {
						self.registros = r.Registros;
					})
					.catch(console.log);
			},
			downloadReport() {
				const fechas = $("#fechaReportePausa").val();
				let [fechaIni, fechaFin] = fechas.split(" - ");
				if (!fechaFin) {
					fechaFin = fechaIni;
				}
				window.location.href = gen_geturl(
					"EstadosPausa/generateReport",
					{
						fechaIni,
						fechaFin,
						csv: true,
					}
				);
			},
		},
		updated() {
			$(".tooltipped").tooltip();
		},
		mounted() {
			const date = new Date()
			$("#fechaReportePausa").val(date.toISOString().split("T").shift())
			this.generateReport();
		},
	});
})();
