<?php
if(!defined('BASEPATH'))
    exit('No direct script access allowed');


/*
|--------------------------------------------------------------------------
| Display Debug backtrace
|--------------------------------------------------------------------------
|
| If set to TRUE, a backtrace will be displayed along with php errors. If
| error_reporting is disabled, the backtrace will not display, regardless
| of this setting
|
 */
defined('SHOW_DEBUG_BACKTRACE') or define('SHOW_DEBUG_BACKTRACE', TRUE);

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
 */
defined('FILE_READ_MODE') or define('FILE_READ_MODE', 0644);
defined('FILE_WRITE_MODE') or define('FILE_WRITE_MODE', 0666);
defined('DIR_READ_MODE') or define('DIR_READ_MODE', 0755);
defined('DIR_WRITE_MODE') or define('DIR_WRITE_MODE', 0755);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
 */
defined('FOPEN_READ') or define('FOPEN_READ', 'rb');
defined('FOPEN_READ_WRITE') or define('FOPEN_READ_WRITE', 'r+b');
defined('FOPEN_WRITE_CREATE_DESTRUCTIVE') or define('FOPEN_WRITE_CREATE_DESTRUCTIVE', 'wb'); // truncates existing file data, use with care
defined('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE') or define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE', 'w+b'); // truncates existing file data, use with care
defined('FOPEN_WRITE_CREATE') or define('FOPEN_WRITE_CREATE', 'ab');
defined('FOPEN_READ_WRITE_CREATE') or define('FOPEN_READ_WRITE_CREATE', 'a+b');
defined('FOPEN_WRITE_CREATE_STRICT') or define('FOPEN_WRITE_CREATE_STRICT', 'xb');
defined('FOPEN_READ_WRITE_CREATE_STRICT') or define('FOPEN_READ_WRITE_CREATE_STRICT', 'x+b');

/*
|--------------------------------------------------------------------------
| Exit Status Codes
|--------------------------------------------------------------------------
|
| Used to indicate the conditions under which the script is exit()ing.
| While there is no universal standard for error codes, there are some
| broad conventions.  Three such conventions are mentioned below, for
| those who wish to make use of them.  The CodeIgniter defaults were
| chosen for the least overlap with these conventions, while still
| leaving room for others to be defined in future versions and user
| applications.
|
| The three main conventions used for determining exit status codes
| are as follows:
|
|    Standard C/C++ Library (stdlibc):
|       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
|       (This link also contains other GNU-specific conventions)
|    BSD sysexits.h:
|       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
|    Bash scripting:
|       http://tldp.org/LDP/abs/html/exitcodes.html
|
 */
defined('EXIT_SUCCESS') or define('EXIT_SUCCESS', 0); // no errors
defined('EXIT_ERROR') or define('EXIT_ERROR', 1); // generic error
defined('EXIT_CONFIG') or define('EXIT_CONFIG', 3); // configuration error
defined('EXIT_UNKNOWN_FILE') or define('EXIT_UNKNOWN_FILE', 4); // file not found
defined('EXIT_UNKNOWN_CLASS') or define('EXIT_UNKNOWN_CLASS', 5); // unknown class
defined('EXIT_UNKNOWN_METHOD') or define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT') or define('EXIT_USER_INPUT', 7); // invalid user input
defined('EXIT_DATABASE') or define('EXIT_DATABASE', 8); // database error
defined('EXIT__AUTO_MIN') or define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX') or define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code

//CONSTANTES UNIVERSALES
defined('VERSION') or define('VERSION', '1.0000');
defined('ROOT_URL') or define('ROOT_URL', '/Dialvox/');
defined('SITE_NAME') or define('SITE_NAME', 'DialVox');
defined('CSS') or define('CSS', ROOT_URL . 'public/homeAgente/css/');
defined('JS') or define('JS', ROOT_URL . 'public/homeAgente/js/');
defined('IMG') or define('IMG', ROOT_URL . 'public/homeAgente/img/');
defined('VENDORAGENTE') or define('VENDORAGENTE', ROOT_URL . 'public/homeAgente/vendor/');
defined('MODULOS') or define('MODULOS', ROOT_URL . 'index.php/');
defined('TIME_ZONE') or define('TIME_ZONE', 'America/Mexico_City');
defined('URL_MODULOS') or define('URL_MODULOS', ROOT_URL . 'application/modules/');
defined('URL_TEMPLATEBACK') or define('URL_TEMPLATEBACK', ROOT_URL . 'application/modules/login/views/include/template/');
defined('VIEW_BACK') or define('VIEW_BACK', ROOT_URL . 'application/views/login/');
defined('ROOT_BACK') or define('ROOT_BACK', ROOT_URL . 'application/views/login/');
defined('URL_VERSION') or define('URL_VERSION', '?v=' . VERSION);
defined('URL_TEMPLATEBACK') or define('URL_TEMPLATEBACK', ROOT_URL . 'application/modules/login/views/include/');
defined('URL_JAVASCRIPT_BACK') or define('URL_JAVASCRIPT_BACK', ROOT_URL . 'application/modules/login/views/include/js/');
defined('URL_ASSETS') or define('URL_ASSETS', ROOT_URL . 'assets/');
defined('URL_IMAGES') or define('URL_IMAGES', URL_ASSETS . 'images/');
defined('ROOT_URL_FRONT') or define('ROOT_URL_FRONT', ROOT_URL . 'login/');
defined('ROOT_URL_IMAGE') or define('ROOT_URL_IMAGE', ROOT_URL . 'assets/logos/loader_auto.gif');
defined('ROOT_URL_FRONT_REDIRECT') or define('ROOT_URL_FRONT_REDIRECT', ROOT_URL);
defined('URL_TEMPLATEFRONT') or define('URL_TEMPLATEFRONT', ROOT_URL . 'application/modules/login/views/include/template/');
defined('VIEW_FRONT') or define('VIEW_FRONT', ROOT_URL . 'application/modules/login/views/');
defined('PHP_RESOURCES') or define('PHP_RESOURCES', ROOT_URL . 'application/modules/login/views/include/resources/');
defined('URL_JAVASCRIPT_FRONT') or define('URL_JAVASCRIPT_FRONT', ROOT_URL . 'application/modules/login/views/include/js/');
defined('TIME_SESSION') or define('TIME_SESSION', 720);
defined('CSS_ADMIN') or define('CSS_ADMIN', ROOT_URL . 'public/homeAdmin/css/');
defined('JS_ADMIN') or define('JS_ADMIN', ROOT_URL . 'public/homeAdmin/js/');
defined('IMG_ADMIN') or define('IMG_ADMIN', ROOT_URL . 'public/homeAdmin/images/');
defined('VENDORS_ADMIN') or define('VENDORS_ADMIN', ROOT_URL . 'public/homeAdmin/vendors/');
defined('TEMPLATES') or define('TEMPLATES', ROOT_URL . 'public/templates/');
defined('LIB_JS') or define('LIB_JS', ROOT_URL . 'public/lib/');
defined('DIALVOX_VERSION') or define('DIALVOX_VERSION', '18.5.8');
defined('CANVAS_ADMIN') or define('CANVAS_ADMIN', ROOT_URL . 'public/homeAdmin/canvas/');


// Ruta para include de html utiles
defined('UTILS_PATH') or
    define(
        'UTILS_PATH',
        __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'views' . DIRECTORY_SEPARATOR . 'utils' . DIRECTORY_SEPARATOR
    );

// Ruta para include de html utiles


//include_once '/srv/www/htdocs/constantesEspecificas.php';

// Lectura de las constantes de base de datos
// cambio respecto a los anteriores archivos
// de constantes   
// ==> include_once '../constantesEspecificas.php';

if (file_exists("/etc/dialvox/configuracion.json")) {
    $strConstantes = file_get_contents("/etc/dialvox/configuracion.json");
    $jsonContantes = json_decode($strConstantes, true);
    foreach ($jsonContantes["ESPECIFICAS"] as $key => $value) {
        defined($key) or define($key, $value);
    }
} else {
    include_once '../constantesEspecificas.php';
}
