<?php
require_once __DIR__ . '/vendor/autoload.php';
use PHPSocketIO\SocketIO;
use Workerman\Worker;
// listen port 2021 for socket.io client
// ssl context
if (file_exists("/etc/dialvox/configuracion.json")) {
    $strConstantes = file_get_contents("/etc/dialvox/configuracion.json");
    $jsonContantes = json_decode($strConstantes, true);
    foreach ($jsonContantes["Chat"] as $key => $value) {
        defined($key) or define($key, $value);
    }
} else {
    require_once '../constantesEspecificas.php';
}

require_once "Conexion.php";
$context = array(
    'ssl' => array(
        'local_cert' => LOCAL_CERT,
        'local_pk' => LOCAL_PK,
        'verify_peer' => false,
    ),
);
$io = new SocketIO(2021, $context);
$io->on('connection', function ($socket) {
    $socket->on('firstTime', function ($data) use ($socket) {
        $con = getConnection2();
        $usuario = $data->usuario;
        $socketId = $data->socketId;
        sv_mysqli_query($con, "UPDATE pertenencia SET idSocket='$socketId' WHERE usuario='$usuario'");
        $mensajes = sv_mysqli_query($con, "SELECT M.usuario,DATE_FORMAT(M.fechaYHora,'%k:%i:%s %d-%m-%Y') as FechaHora,M.mensaje,M.idsalaChat,SC.nombre AS nombreSala FROM mensajes AS M INNER JOIN pertenencia AS P ON P.idSala=M.idsalaChat INNER JOIN salaChat AS SC ON SC.idsalaChat=M.idsalaChat WHERE P.usuario='$usuario' ORDER BY fechaYHora DESC");
        $sal = array();
        $sal["Mensajes"] = array();
        while ($mensaje = sv_mysqli_fetch_array($mensajes)) {
            $sal["Mensajes"][] = array("usuario" => $mensaje["usuario"], "fecha" => $mensaje["FechaHora"], "mensaje" => $mensaje["mensaje"], "sala" => $mensaje["idsalaChat"], "nombreSala" => $mensaje["nombreSala"]);
        }
        $socket->broadcast->to($socketId)->emit("finallyConnect", $sal);
        sv_mysqli_close($con);
    });
    $socket->on('join', function ($data) use ($socket) {
        $con = getConnection2();
        $usuario = $data->usuario;
        $socketId = $data->socketId;
        $idSala = $data->idSala;
        sv_mysqli_query($con, "UPDATE pertenencia SET idSocket='$socketId' WHERE usuario='$usuario' AND idSala='$idSala'");
        $mensajes = sv_mysqli_query($con, "SELECT M.usuario,DATE_FORMAT(M.fechaYHora,'%k:%i:%s %d-%m-%Y') as FechaHora,M.mensaje,SC.nombre AS nombreSala FROM mensajes AS M INNER JOIN salaChat AS SC ON SC.idsalaChat=M.idsalaChat WHERE idsalaChat='$idSala' ORDER BY fechaYHora DESC");
        $sal = array();
        $sal["Mensajes"] = array();
        while ($mensaje = sv_mysqli_fetch_array($mensajes)) {
            $sal["Mensajes"][] = array("usuario" => $mensaje["usuario"], "fecha" => $mensaje["FechaHora"], "mensaje" => $mensaje["mensaje"], "nombreSala" => $mensaje["nombreSala"]);
        }
        $sal["idSala"] = $idSala;
        $socket->broadcast->to($socketId)->emit("finallyJoin", $sal);
        sv_mysqli_close($con);
    });
    $socket->on('send', function ($data) use ($socket) {
        $con = getConnection2();
        $usuario = $data->usuario;
        $socketId = $data->socketId;
        $idSala = $data->idSala;
        $mensajeStr = $data->mensaje;
        sv_mysqli_query($con, "INSERT INTO mensajes(usuario,mensaje,idsalaChat) VALUES('$usuario','$mensajeStr','$idSala')");
        $idMensaje = mysqli_insert_id($con);
        $mensaje = sv_mysqli_fetch_array(sv_mysqli_query($con, "SELECT M.usuario,DATE_FORMAT(fM.echaYHora,'%k:%i:%s %d-%m-%Y') as FechaHora,M.mensaje,SC.nombre AS nombreSala FROM mensajes AS M INNER JOIN salaChat AS SC ON SC.idsalaChat=M.idsalaChat WHERE idmensajes='$idMensaje'"));
        $contactos = sv_mysqli_query($con, "SELECT idSocket FROM pertenencia WHERE idSala='$idSala' AND usuario<>'$usuario' AND idSocket<>''");
        while ($contacto = sv_mysqli_fetch_array($contactos)) {
            $sal = array("Mensaje" => []);
            $sal["Mensaje"] = array(
                "usuario" => $mensaje["usuario"], "fecha" => $mensaje["FechaHora"], "mensaje" => $mensaje["mensaje"],
                "sala" => $idSala,
                "nombreSala" => $mensaje["nombreSala"],
            );
            $socket->broadcast->to($contacto["idSocket"])->emit("receive", $sal);
        }
        sv_mysqli_close($con);
    });
});

Worker::runAll();
