<modal-dialvox v-model="modalLeadDetails" @close="cerrarDetalles" :disabled="true" cancel="Cerrar">
    <h4>{{traducirFrase("Detalles del Lead")}} {{ leadDetails.leadId }}</h4>
    <br><br>
    <div class="container">
        <div class="row dv-flex no-bottom">
            <div class="col dv-flex-grow-1 input-field">
                <input type="text" placeholder="Telefono" readonly="readonly" v-model="leadDetails.leadInfo.phone_number">
                <label class="active">{{traducirFrase("Telefono")}}</label>
            </div>
            <div class="col dv-flex-grow-1 input-field" v-if="leadDetails.leadInfo.alt_phone !== ''" >
                <input type="text" placeholder="Telefono alterno" readonly="readonly" v-model="leadDetails.leadInfo.alt_phone">
                <label class="active">{{traducirFrase("Telefono alterno")}}</label>
            </div>
        </div>
        <div class="row dv-flex no-bottom" v-if="leadDetails.leadInfo.first_name !== '' || leadDetails.leadInfo.last_name !== ''">
            <div class="col dv-flex-grow-1 input-field" v-if="leadDetails.leadInfo.first_name !== ''">
                <input type="text" placeholder="Nombre" readonly="readonly" v-model="leadDetails.leadInfo.first_name">
                <label class="active">{{traducirFrase("Nombre")}}</label>
            </div>
            <div class="col dv-flex-grow-1 input-field" v-if="leadDetails.leadInfo.last_name !== ''">
                <input type="text" placeholder="Apellido" readonly="readonly" v-model="leadDetails.leadInfo.last_name">
                <label class="active">{{traducirFrase("Apellido")}}</label>
            </div>
        </div>
        <div class="row">
            <h6>{{traducirFrase("Registros de llamadas")}}</h6>
            <div class="row col s12">
                <table-dialvox
                    :headers="headersLeadDetails.calls"
                    :data="leadDetails.calls"
                    :hsearch="true"
                />
            </div>
        </div>
        <div class="row">
            <h6>{{traducirFrase("Registros de agentes")}}</h6>
            <div class="row col s12">
                <table-dialvox
                    :headers="headersLeadDetails.agent"
                    :data="leadDetails.agent"
                    :hsearch="true"
                />
            </div>
        </div>
        <div class="row">
            <h6>{{traducirFrase("Registros de entrantes")}}</h6>
            <div class="row col s12">
                <table-dialvox
                    :headers="headersLeadDetails.closer"
                    :data="leadDetails.closer"
                    :hsearch="true"
                />
            </div>
        </div>
        <div class="row">
            <h6>{{traducirFrase("Registros de espera")}}</h6>
            <div class="row col s12">
                <table-dialvox
                    :headers="headersLeadDetails.park"
                    :data="leadDetails.park"
                    :hsearch="true"
                />
            </div>
        </div>
        <div class="row">
            <h6>{{traducirFrase("Registros de IVR")}}</h6>
            <div class="row col s12">
                <table-dialvox
                    :headers="headersLeadDetails.ivr"
                    :data="leadDetails.ivr"
                    :hsearch="true"
                />
            </div>
        </div>
    </div>
</modal-dialvox>
