<modal-dialvox 
    v-model="targets.omnicanalidad" 
    :cancel="traducirFrase('Cancelar')" 
    :disabled="true" 
    @closed="closeSections()"
>
    <h4>{{traducirFrase("Omnicanalidad")}}</h4>
    <br>
    <div class="container" style="display:flex;flex-direction:column;">
        <div style="display: flex; flex-direction:column; padding: 0.8rem 0.2rem; border-bottom:solid 1px #eaeaea; border-top:solid 1px #eaeaea;" v-for="config in configOmnicanalidad">
            <div style="display: flex; flex-direction:row; gap: 1rem;">
                <div class="input-field" style="flex-grow:1;">
                    <input type="text" v-model="config.label" placeholder="Nombre" :readonly="!config.isEditing">
                    <label class="active">{{traducirFrase("Nombre")}}</label>
                </div>
                <div class="input-field" style="flex-grow:1;">
                    <input type="text" v-model="config.url" placeholder="URL" :readonly="!config.isEditing">
                    <label class="active">{{traducirFrase("URL")}}</label>
                </div>
            </div>
            <div style="display: flex; flex-direction:row; gap: 1rem;">
                <div class="input-field" style="flex-grow:1;">
                    <input type="text" v-model="config.userField" placeholder="Campo usuario" :readonly="!config.isEditing">
                    <label class="active">{{traducirFrase("Campo usuario")}}</label>
                    <span class="helper-text">{{traducirFrase("Nombre del campo de usuario")}}</span>
                </div>
                <div class="input-field" style="flex-grow:1;">
                    <input type="text" v-model="config.userValue" placeholder="Usuario" :readonly="!config.isEditing">
                    <label class="active">{{traducirFrase("Usuario")}}</label>
                    <span class="helper-text">{{traducirFrase("Usuario para acceder")}}</span>
                </div>
            </div>
            <div style="display: flex; flex-direction:row; gap: 1rem;">
                <div class="input-field" style="flex-grow:1;">
                    <input type="text" v-model="config.passwordField" placeholder="Campo usuario" :readonly="!config.isEditing">
                    <label class="active">{{traducirFrase("Campo contraseña")}}</label>
                    <span class="helper-text">{{traducirFrase("Nombre del campo de la contraseña")}}</span>
                </div>
                <div class="input-field" style="flex-grow:1;">
                    <input type="text" v-model="config.passwordValue" placeholder="Contraseña" :readonly="!config.isEditing">
                    <label class="active">{{traducirFrase("Contraseña")}}</label>
                    <span class="helper-text">{{traducirFrase("Contraseña para acceder")}}</span>
                </div>
            </div>
            <div style="display: flex; flex-direction:row; gap: 1rem;">
                <div class="input-field" style="flex-grow:1;">
                    <input type="text" v-model="config.loginURL" placeholder="URL de login" :readonly="!config.isEditing">
                    <label class="active">{{traducirFrase("URL de login")}}</label>
                    <span class="helper-text">{{traducirFrase("URL a donde se envían la iformación para el login.")}}</span>
                </div>
                <div class="input-field" style="flex-grow:1;">
                    <input type="text" v-model="config.redirectURL" placeholder="URL para redirigir" :readonly="!config.isEditing">
                    <label class="active">{{traducirFrase("URL para redirigir")}}</label>
                    <span class="helper-text">{{traducirFrase("URL que redirigirá después de iniciar sesión. Es Opcional.")}}</span>
                </div>
            </div>
            <div style="display: flex; flex-direction:row; gap: 1rem;">
                <div class="input-field" style="flex-grow:1;">
                    <i class='material-icons prefix'>{{config.icon}}</i>
                    <input type="text" v-model="config.icon" placeholder="Icono" :readonly="!config.isEditing">
                    <label for="" class="active">{{traducirFrase("Icono")}}</label>
                    <span class="helper-text">
                        {{traducirFrase("Icono que aparece en la barra de navegación para la sección")}}
                    </span>
                </div>
            </div>
            <div style="display: flex; flex-direction: row; justify-content:flex-end; gap: 1rem; margin: 0.2rem 0;" v-if="!config.isEditing">
                <button class="btn-small z-depth-0 grey lighten-4 waves-effect waves-teal" @click="config.isEditing = true">
                    <i class="material-icons teal-text">edit</i>
                </button>
                <button class="btn-small z-depth-0 grey lighten-4 waves-effect waves-red" @click="deleteSection(config, true)">
                    <i class="material-icons red-text">delete</i>
                </button>
            </div>
            <div style="display: flex; flex-direction: row; gap: 1rem; justify-content:flex-end; margin: 0.2rem 0;" v-if="config.isEditing">
                <button class="btn-small z-depth-0 grey lighten-4 waves-effect waves-light blue-grey-text" @click="omnicanalidad(id_cliente)">
                    Cancelar
                </button>
                <button class="btn-small z-depth-0 grey lighten-4 waves-effect waves-teal teal-text" @click="saveSection(config, true)">
                    Guardar
                </button>
            </div>
        </div>
        <div style="display: flex; flex-direction:column; gap: 0.2rem; padding: 0.8rem 0.2rem;">
            <div style="display: flex; flex-direction: row; gap: 1rem; justify-content:flex-end; margin: 0.2rem 0;">
                <button class="dropdown-trigger btn-small z-depth-0 grey lighten-4 waves-effect waves-light blue-grey-text" data-target="presets-omnicanalidad">
                    Nueva seccion
                </button>
            </div>
        </div>
    </div>
    <ul id='presets-omnicanalidad' class='dropdown-content'>
        <li v-for="preset in omnicanalidadPresets">
            <a href="#!" @click="addSection(true, preset)">{{preset.label}}</a>
        </li>
        <li>
            <a href="#!" @click="addSection(true)">Otro</a>
        </li>
    </ul>
</modal-dialvox>